import { APIResource } from "../../../../resource.js";
import * as Core from "../../../../core.js";
export declare class Summary extends APIResource {
    /**
     * Retrieves the distribution of unique accounts by model.
     */
    model(query?: SummaryModelParams, options?: Core.RequestOptions): Core.APIPromise<SummaryModelResponse>;
    model(options?: Core.RequestOptions): Core.APIPromise<SummaryModelResponse>;
    /**
     * Retrieves the distribution of unique accounts by task.
     */
    task(query?: SummaryTaskParams, options?: Core.RequestOptions): Core.APIPromise<SummaryTaskResponse>;
    task(options?: Core.RequestOptions): Core.APIPromise<SummaryTaskResponse>;
}
export interface SummaryModelResponse {
    meta: SummaryModelResponse.Meta;
    summary_0: Record<string, string>;
}
export declare namespace SummaryModelResponse {
    interface Meta {
        dateRange: Array<Meta.DateRange>;
        lastUpdated: string;
        normalization: string;
        confidenceInfo?: Meta.ConfidenceInfo;
    }
    namespace Meta {
        interface DateRange {
            /**
             * Adjusted end of date range.
             */
            endTime: string;
            /**
             * Adjusted start of date range.
             */
            startTime: string;
        }
        interface ConfidenceInfo {
            annotations?: Array<ConfidenceInfo.Annotation>;
            level?: number;
        }
        namespace ConfidenceInfo {
            interface Annotation {
                dataSource: string;
                description: string;
                eventType: string;
                isInstantaneous: boolean;
                endTime?: string;
                linkedUrl?: string;
                startTime?: string;
            }
        }
    }
}
export interface SummaryTaskResponse {
    meta: SummaryTaskResponse.Meta;
    summary_0: Record<string, string>;
}
export declare namespace SummaryTaskResponse {
    interface Meta {
        dateRange: Array<Meta.DateRange>;
        lastUpdated: string;
        normalization: string;
        confidenceInfo?: Meta.ConfidenceInfo;
    }
    namespace Meta {
        interface DateRange {
            /**
             * Adjusted end of date range.
             */
            endTime: string;
            /**
             * Adjusted start of date range.
             */
            startTime: string;
        }
        interface ConfidenceInfo {
            annotations?: Array<ConfidenceInfo.Annotation>;
            level?: number;
        }
        namespace ConfidenceInfo {
            interface Annotation {
                dataSource: string;
                description: string;
                eventType: string;
                isInstantaneous: boolean;
                endTime?: string;
                linkedUrl?: string;
                startTime?: string;
            }
        }
    }
}
export interface SummaryModelParams {
    /**
     * End of the date range (inclusive).
     */
    dateEnd?: Array<string>;
    /**
     * Filters results by the specified date range. For example, use `7d` and
     * `7dcontrol` to compare this week with the previous week. Use this parameter or
     * set specific start and end dates (`dateStart` and `dateEnd` parameters).
     */
    dateRange?: Array<string>;
    /**
     * Start of the date range.
     */
    dateStart?: Array<string>;
    /**
     * Format in which results will be returned.
     */
    format?: 'JSON' | 'CSV';
    /**
     * Limits the number of objects per group to the top items within the specified
     * time range. If there are more items than the limit, the response will include
     * the count of items, with any remaining items grouped together under an "other"
     * category.
     */
    limitPerGroup?: number;
    /**
     * Array of names used to label the series in the response.
     */
    name?: Array<string>;
}
export interface SummaryTaskParams {
    /**
     * End of the date range (inclusive).
     */
    dateEnd?: Array<string>;
    /**
     * Filters results by the specified date range. For example, use `7d` and
     * `7dcontrol` to compare this week with the previous week. Use this parameter or
     * set specific start and end dates (`dateStart` and `dateEnd` parameters).
     */
    dateRange?: Array<string>;
    /**
     * Start of the date range.
     */
    dateStart?: Array<string>;
    /**
     * Format in which results will be returned.
     */
    format?: 'JSON' | 'CSV';
    /**
     * Limits the number of objects per group to the top items within the specified
     * time range. If there are more items than the limit, the response will include
     * the count of items, with any remaining items grouped together under an "other"
     * category.
     */
    limitPerGroup?: number;
    /**
     * Array of names used to label the series in the response.
     */
    name?: Array<string>;
}
export declare namespace Summary {
    export { type SummaryModelResponse as SummaryModelResponse, type SummaryTaskResponse as SummaryTaskResponse, type SummaryModelParams as SummaryModelParams, type SummaryTaskParams as SummaryTaskParams, };
}
//# sourceMappingURL=summary.d.ts.map