import { APIResource } from "../../../../resource.js";
import * as Core from "../../../../core.js";
export declare class Summary extends APIResource {
    /**
     * Retrieves the distribution of layer 3 attacks by bitrate.
     */
    bitrate(query?: SummaryBitrateParams, options?: Core.RequestOptions): Core.APIPromise<SummaryBitrateResponse>;
    bitrate(options?: Core.RequestOptions): Core.APIPromise<SummaryBitrateResponse>;
    /**
     * Retrieves the distribution of layer 3 attacks by duration.
     */
    duration(query?: SummaryDurationParams, options?: Core.RequestOptions): Core.APIPromise<SummaryDurationResponse>;
    duration(options?: Core.RequestOptions): Core.APIPromise<SummaryDurationResponse>;
    /**
     * Retrieves the distribution of layer 3 attacks by IP version.
     */
    ipVersion(query?: SummaryIPVersionParams, options?: Core.RequestOptions): Core.APIPromise<SummaryIPVersionResponse>;
    ipVersion(options?: Core.RequestOptions): Core.APIPromise<SummaryIPVersionResponse>;
    /**
     * Retrieves the distribution of layer 3 attacks by protocol.
     */
    protocol(query?: SummaryProtocolParams, options?: Core.RequestOptions): Core.APIPromise<SummaryProtocolResponse>;
    protocol(options?: Core.RequestOptions): Core.APIPromise<SummaryProtocolResponse>;
    /**
     * Retrieves the distribution of layer 3 attacks by vector.
     */
    vector(query?: SummaryVectorParams, options?: Core.RequestOptions): Core.APIPromise<SummaryVectorResponse>;
    vector(options?: Core.RequestOptions): Core.APIPromise<SummaryVectorResponse>;
}
export interface SummaryBitrateResponse {
    meta: SummaryBitrateResponse.Meta;
    summary_0: SummaryBitrateResponse.Summary0;
}
export declare namespace SummaryBitrateResponse {
    interface Meta {
        dateRange: Array<Meta.DateRange>;
        lastUpdated: string;
        normalization: string;
        confidenceInfo?: Meta.ConfidenceInfo;
    }
    namespace Meta {
        interface DateRange {
            /**
             * Adjusted end of date range.
             */
            endTime: string;
            /**
             * Adjusted start of date range.
             */
            startTime: string;
        }
        interface ConfidenceInfo {
            annotations?: Array<ConfidenceInfo.Annotation>;
            level?: number;
        }
        namespace ConfidenceInfo {
            interface Annotation {
                dataSource: string;
                description: string;
                eventType: string;
                isInstantaneous: boolean;
                endTime?: string;
                linkedUrl?: string;
                startTime?: string;
            }
        }
    }
    interface Summary0 {
        _1_GBPS_TO_10_GBPS: string;
        _10_GBPS_TO_100_GBPS: string;
        _500_MBPS_TO_1_GBPS: string;
        OVER_100_GBPS: string;
        UNDER_500_MBPS: string;
    }
}
export interface SummaryDurationResponse {
    meta: SummaryDurationResponse.Meta;
    summary_0: SummaryDurationResponse.Summary0;
}
export declare namespace SummaryDurationResponse {
    interface Meta {
        dateRange: Array<Meta.DateRange>;
        lastUpdated: string;
        normalization: string;
        confidenceInfo?: Meta.ConfidenceInfo;
    }
    namespace Meta {
        interface DateRange {
            /**
             * Adjusted end of date range.
             */
            endTime: string;
            /**
             * Adjusted start of date range.
             */
            startTime: string;
        }
        interface ConfidenceInfo {
            annotations?: Array<ConfidenceInfo.Annotation>;
            level?: number;
        }
        namespace ConfidenceInfo {
            interface Annotation {
                dataSource: string;
                description: string;
                eventType: string;
                isInstantaneous: boolean;
                endTime?: string;
                linkedUrl?: string;
                startTime?: string;
            }
        }
    }
    interface Summary0 {
        _1_HOUR_TO_3_HOURS: string;
        _10_MINS_TO_20_MINS: string;
        _20_MINS_TO_40_MINS: string;
        _40_MINS_TO_1_HOUR: string;
        OVER_3_HOURS: string;
        UNDER_10_MINS: string;
    }
}
export interface SummaryIPVersionResponse {
    meta: SummaryIPVersionResponse.Meta;
    summary_0: SummaryIPVersionResponse.Summary0;
}
export declare namespace SummaryIPVersionResponse {
    interface Meta {
        dateRange: Array<Meta.DateRange>;
        lastUpdated: string;
        normalization: string;
        confidenceInfo?: Meta.ConfidenceInfo;
    }
    namespace Meta {
        interface DateRange {
            /**
             * Adjusted end of date range.
             */
            endTime: string;
            /**
             * Adjusted start of date range.
             */
            startTime: string;
        }
        interface ConfidenceInfo {
            annotations?: Array<ConfidenceInfo.Annotation>;
            level?: number;
        }
        namespace ConfidenceInfo {
            interface Annotation {
                dataSource: string;
                description: string;
                eventType: string;
                isInstantaneous: boolean;
                endTime?: string;
                linkedUrl?: string;
                startTime?: string;
            }
        }
    }
    interface Summary0 {
        IPv4: string;
        IPv6: string;
    }
}
export interface SummaryProtocolResponse {
    meta: SummaryProtocolResponse.Meta;
    summary_0: SummaryProtocolResponse.Summary0;
}
export declare namespace SummaryProtocolResponse {
    interface Meta {
        dateRange: Array<Meta.DateRange>;
        lastUpdated: string;
        normalization: string;
        confidenceInfo?: Meta.ConfidenceInfo;
    }
    namespace Meta {
        interface DateRange {
            /**
             * Adjusted end of date range.
             */
            endTime: string;
            /**
             * Adjusted start of date range.
             */
            startTime: string;
        }
        interface ConfidenceInfo {
            annotations?: Array<ConfidenceInfo.Annotation>;
            level?: number;
        }
        namespace ConfidenceInfo {
            interface Annotation {
                dataSource: string;
                description: string;
                eventType: string;
                isInstantaneous: boolean;
                endTime?: string;
                linkedUrl?: string;
                startTime?: string;
            }
        }
    }
    interface Summary0 {
        GRE: string;
        ICMP: string;
        TCP: string;
        UDP: string;
    }
}
export interface SummaryVectorResponse {
    meta: SummaryVectorResponse.Meta;
    summary_0: Record<string, string>;
}
export declare namespace SummaryVectorResponse {
    interface Meta {
        dateRange: Array<Meta.DateRange>;
        lastUpdated: string;
        normalization: string;
        confidenceInfo?: Meta.ConfidenceInfo;
    }
    namespace Meta {
        interface DateRange {
            /**
             * Adjusted end of date range.
             */
            endTime: string;
            /**
             * Adjusted start of date range.
             */
            startTime: string;
        }
        interface ConfidenceInfo {
            annotations?: Array<ConfidenceInfo.Annotation>;
            level?: number;
        }
        namespace ConfidenceInfo {
            interface Annotation {
                dataSource: string;
                description: string;
                eventType: string;
                isInstantaneous: boolean;
                endTime?: string;
                linkedUrl?: string;
                startTime?: string;
            }
        }
    }
}
export interface SummaryBitrateParams {
    /**
     * Comma-separated list of continents (alpha-2 continent codes). Prefix with `-` to
     * exclude continents from results. For example, `-EU,NA` excludes results from EU,
     * but includes results from NA.
     */
    continent?: Array<string>;
    /**
     * End of the date range (inclusive).
     */
    dateEnd?: Array<string>;
    /**
     * Filters results by the specified date range. For example, use `7d` and
     * `7dcontrol` to compare this week with the previous week. Use this parameter or
     * set specific start and end dates (`dateStart` and `dateEnd` parameters).
     */
    dateRange?: Array<string>;
    /**
     * Start of the date range.
     */
    dateStart?: Array<string>;
    /**
     * Together with the `location` parameter, will apply the filter to origin or
     * target location.
     */
    direction?: 'ORIGIN' | 'TARGET';
    /**
     * Format in which results will be returned.
     */
    format?: 'JSON' | 'CSV';
    /**
     * Filters results by IP version (Ipv4 vs. IPv6).
     */
    ipVersion?: Array<'IPv4' | 'IPv6'>;
    /**
     * Comma-separated list of locations (alpha-2 codes). Prefix with `-` to exclude
     * locations from results. For example, `-US,PT` excludes results from the US, but
     * includes results from PT.
     */
    location?: Array<string>;
    /**
     * Array of names used to label the series in the response.
     */
    name?: Array<string>;
    /**
     * Array of L3/4 attack types.
     */
    protocol?: Array<'UDP' | 'TCP' | 'ICMP' | 'GRE'>;
}
export interface SummaryDurationParams {
    /**
     * Comma-separated list of continents (alpha-2 continent codes). Prefix with `-` to
     * exclude continents from results. For example, `-EU,NA` excludes results from EU,
     * but includes results from NA.
     */
    continent?: Array<string>;
    /**
     * End of the date range (inclusive).
     */
    dateEnd?: Array<string>;
    /**
     * Filters results by the specified date range. For example, use `7d` and
     * `7dcontrol` to compare this week with the previous week. Use this parameter or
     * set specific start and end dates (`dateStart` and `dateEnd` parameters).
     */
    dateRange?: Array<string>;
    /**
     * Start of the date range.
     */
    dateStart?: Array<string>;
    /**
     * Together with the `location` parameter, will apply the filter to origin or
     * target location.
     */
    direction?: 'ORIGIN' | 'TARGET';
    /**
     * Format in which results will be returned.
     */
    format?: 'JSON' | 'CSV';
    /**
     * Filters results by IP version (Ipv4 vs. IPv6).
     */
    ipVersion?: Array<'IPv4' | 'IPv6'>;
    /**
     * Comma-separated list of locations (alpha-2 codes). Prefix with `-` to exclude
     * locations from results. For example, `-US,PT` excludes results from the US, but
     * includes results from PT.
     */
    location?: Array<string>;
    /**
     * Array of names used to label the series in the response.
     */
    name?: Array<string>;
    /**
     * Array of L3/4 attack types.
     */
    protocol?: Array<'UDP' | 'TCP' | 'ICMP' | 'GRE'>;
}
export interface SummaryIPVersionParams {
    /**
     * Comma-separated list of continents (alpha-2 continent codes). Prefix with `-` to
     * exclude continents from results. For example, `-EU,NA` excludes results from EU,
     * but includes results from NA.
     */
    continent?: Array<string>;
    /**
     * End of the date range (inclusive).
     */
    dateEnd?: Array<string>;
    /**
     * Filters results by the specified date range. For example, use `7d` and
     * `7dcontrol` to compare this week with the previous week. Use this parameter or
     * set specific start and end dates (`dateStart` and `dateEnd` parameters).
     */
    dateRange?: Array<string>;
    /**
     * Start of the date range.
     */
    dateStart?: Array<string>;
    /**
     * Together with the `location` parameter, will apply the filter to origin or
     * target location.
     */
    direction?: 'ORIGIN' | 'TARGET';
    /**
     * Format in which results will be returned.
     */
    format?: 'JSON' | 'CSV';
    /**
     * Comma-separated list of locations (alpha-2 codes). Prefix with `-` to exclude
     * locations from results. For example, `-US,PT` excludes results from the US, but
     * includes results from PT.
     */
    location?: Array<string>;
    /**
     * Array of names used to label the series in the response.
     */
    name?: Array<string>;
    /**
     * Array of L3/4 attack types.
     */
    protocol?: Array<'UDP' | 'TCP' | 'ICMP' | 'GRE'>;
}
export interface SummaryProtocolParams {
    /**
     * Comma-separated list of continents (alpha-2 continent codes). Prefix with `-` to
     * exclude continents from results. For example, `-EU,NA` excludes results from EU,
     * but includes results from NA.
     */
    continent?: Array<string>;
    /**
     * End of the date range (inclusive).
     */
    dateEnd?: Array<string>;
    /**
     * Filters results by the specified date range. For example, use `7d` and
     * `7dcontrol` to compare this week with the previous week. Use this parameter or
     * set specific start and end dates (`dateStart` and `dateEnd` parameters).
     */
    dateRange?: Array<string>;
    /**
     * Start of the date range.
     */
    dateStart?: Array<string>;
    /**
     * Together with the `location` parameter, will apply the filter to origin or
     * target location.
     */
    direction?: 'ORIGIN' | 'TARGET';
    /**
     * Format in which results will be returned.
     */
    format?: 'JSON' | 'CSV';
    /**
     * Filters results by IP version (Ipv4 vs. IPv6).
     */
    ipVersion?: Array<'IPv4' | 'IPv6'>;
    /**
     * Comma-separated list of locations (alpha-2 codes). Prefix with `-` to exclude
     * locations from results. For example, `-US,PT` excludes results from the US, but
     * includes results from PT.
     */
    location?: Array<string>;
    /**
     * Array of names used to label the series in the response.
     */
    name?: Array<string>;
}
export interface SummaryVectorParams {
    /**
     * Comma-separated list of continents (alpha-2 continent codes). Prefix with `-` to
     * exclude continents from results. For example, `-EU,NA` excludes results from EU,
     * but includes results from NA.
     */
    continent?: Array<string>;
    /**
     * End of the date range (inclusive).
     */
    dateEnd?: Array<string>;
    /**
     * Filters results by the specified date range. For example, use `7d` and
     * `7dcontrol` to compare this week with the previous week. Use this parameter or
     * set specific start and end dates (`dateStart` and `dateEnd` parameters).
     */
    dateRange?: Array<string>;
    /**
     * Start of the date range.
     */
    dateStart?: Array<string>;
    /**
     * Together with the `location` parameter, will apply the filter to origin or
     * target location.
     */
    direction?: 'ORIGIN' | 'TARGET';
    /**
     * Format in which results will be returned.
     */
    format?: 'JSON' | 'CSV';
    /**
     * Filters results by IP version (Ipv4 vs. IPv6).
     */
    ipVersion?: Array<'IPv4' | 'IPv6'>;
    /**
     * Limits the number of objects per group to the top items within the specified
     * time range. If there are more items than the limit, the response will include
     * the count of items, with any remaining items grouped together under an "other"
     * category.
     */
    limitPerGroup?: number;
    /**
     * Comma-separated list of locations (alpha-2 codes). Prefix with `-` to exclude
     * locations from results. For example, `-US,PT` excludes results from the US, but
     * includes results from PT.
     */
    location?: Array<string>;
    /**
     * Array of names used to label the series in the response.
     */
    name?: Array<string>;
    /**
     * Array of L3/4 attack types.
     */
    protocol?: Array<'UDP' | 'TCP' | 'ICMP' | 'GRE'>;
}
export declare namespace Summary {
    export { type SummaryBitrateResponse as SummaryBitrateResponse, type SummaryDurationResponse as SummaryDurationResponse, type SummaryIPVersionResponse as SummaryIPVersionResponse, type SummaryProtocolResponse as SummaryProtocolResponse, type SummaryVectorResponse as SummaryVectorResponse, type SummaryBitrateParams as SummaryBitrateParams, type SummaryDurationParams as SummaryDurationParams, type SummaryIPVersionParams as SummaryIPVersionParams, type SummaryProtocolParams as SummaryProtocolParams, type SummaryVectorParams as SummaryVectorParams, };
}
//# sourceMappingURL=summary.d.ts.map