import { APIResource } from "../../../../../resource.js";
import * as Core from "../../../../../core.js";
import * as LocationsAPI from "./locations.js";
import { LocationOriginParams, LocationOriginResponse, LocationTargetParams, LocationTargetResponse, Locations } from "./locations.js";
export declare class Top extends APIResource {
    locations: LocationsAPI.Locations;
    /**
     * Retrieves the top layer 3 attacks from origin to target location. Values are a
     * percentage out of the total layer 3 attacks (with billing country). You can
     * optionally limit the number of attacks by origin/target location (useful if all
     * the top attacks are from or to the same location).
     */
    attacks(query?: TopAttacksParams, options?: Core.RequestOptions): Core.APIPromise<TopAttacksResponse>;
    attacks(options?: Core.RequestOptions): Core.APIPromise<TopAttacksResponse>;
    /**
     * Retrieves the top industries targeted by layer 3 attacks.
     */
    industry(query?: TopIndustryParams, options?: Core.RequestOptions): Core.APIPromise<TopIndustryResponse>;
    industry(options?: Core.RequestOptions): Core.APIPromise<TopIndustryResponse>;
    /**
     * Retrieves the top verticals targeted by layer 3 attacks.
     */
    vertical(query?: TopVerticalParams, options?: Core.RequestOptions): Core.APIPromise<TopVerticalResponse>;
    vertical(options?: Core.RequestOptions): Core.APIPromise<TopVerticalResponse>;
}
export interface TopAttacksResponse {
    meta: TopAttacksResponse.Meta;
    top_0: Array<TopAttacksResponse.Top0>;
}
export declare namespace TopAttacksResponse {
    interface Meta {
        dateRange: Array<Meta.DateRange>;
        lastUpdated: string;
        confidenceInfo?: Meta.ConfidenceInfo;
    }
    namespace Meta {
        interface DateRange {
            /**
             * Adjusted end of date range.
             */
            endTime: string;
            /**
             * Adjusted start of date range.
             */
            startTime: string;
        }
        interface ConfidenceInfo {
            annotations?: Array<ConfidenceInfo.Annotation>;
            level?: number;
        }
        namespace ConfidenceInfo {
            interface Annotation {
                dataSource: string;
                description: string;
                eventType: string;
                isInstantaneous: boolean;
                endTime?: string;
                linkedUrl?: string;
                startTime?: string;
            }
        }
    }
    interface Top0 {
        originCountryAlpha2: string;
        originCountryName: string;
        value: string;
    }
}
export interface TopIndustryResponse {
    meta: TopIndustryResponse.Meta;
    top_0: Array<TopIndustryResponse.Top0>;
}
export declare namespace TopIndustryResponse {
    interface Meta {
        dateRange: Array<Meta.DateRange>;
        lastUpdated: string;
        confidenceInfo?: Meta.ConfidenceInfo;
    }
    namespace Meta {
        interface DateRange {
            /**
             * Adjusted end of date range.
             */
            endTime: string;
            /**
             * Adjusted start of date range.
             */
            startTime: string;
        }
        interface ConfidenceInfo {
            annotations?: Array<ConfidenceInfo.Annotation>;
            level?: number;
        }
        namespace ConfidenceInfo {
            interface Annotation {
                dataSource: string;
                description: string;
                eventType: string;
                isInstantaneous: boolean;
                endTime?: string;
                linkedUrl?: string;
                startTime?: string;
            }
        }
    }
    interface Top0 {
        name: string;
        value: string;
    }
}
export interface TopVerticalResponse {
    meta: TopVerticalResponse.Meta;
    top_0: Array<TopVerticalResponse.Top0>;
}
export declare namespace TopVerticalResponse {
    interface Meta {
        dateRange: Array<Meta.DateRange>;
        lastUpdated: string;
        confidenceInfo?: Meta.ConfidenceInfo;
    }
    namespace Meta {
        interface DateRange {
            /**
             * Adjusted end of date range.
             */
            endTime: string;
            /**
             * Adjusted start of date range.
             */
            startTime: string;
        }
        interface ConfidenceInfo {
            annotations?: Array<ConfidenceInfo.Annotation>;
            level?: number;
        }
        namespace ConfidenceInfo {
            interface Annotation {
                dataSource: string;
                description: string;
                eventType: string;
                isInstantaneous: boolean;
                endTime?: string;
                linkedUrl?: string;
                startTime?: string;
            }
        }
    }
    interface Top0 {
        name: string;
        value: string;
    }
}
export interface TopAttacksParams {
    /**
     * Comma-separated list of continents (alpha-2 continent codes). Prefix with `-` to
     * exclude continents from results. For example, `-EU,NA` excludes results from EU,
     * but includes results from NA.
     */
    continent?: Array<string>;
    /**
     * End of the date range (inclusive).
     */
    dateEnd?: Array<string>;
    /**
     * Filters results by the specified date range. For example, use `7d` and
     * `7dcontrol` to compare this week with the previous week. Use this parameter or
     * set specific start and end dates (`dateStart` and `dateEnd` parameters).
     */
    dateRange?: Array<string>;
    /**
     * Start of the date range.
     */
    dateStart?: Array<string>;
    /**
     * Format in which results will be returned.
     */
    format?: 'JSON' | 'CSV';
    /**
     * Filters results by IP version (Ipv4 vs. IPv6).
     */
    ipVersion?: Array<'IPv4' | 'IPv6'>;
    /**
     * Limits the number of objects returned in the response.
     */
    limit?: number;
    /**
     * Array of attack origin/target location attack limits. Together with
     * `limitPerLocation`, limits how many objects will be fetched per origin/target
     * location.
     */
    limitDirection?: 'ORIGIN' | 'TARGET';
    /**
     * Limits the number of attacks per origin/target (refer to `limitDirection`
     * parameter) location.
     */
    limitPerLocation?: number;
    /**
     * Comma-separated list of locations (alpha-2 codes). Prefix with `-` to exclude
     * locations from results. For example, `-US,PT` excludes results from the US, but
     * includes results from PT.
     */
    location?: Array<string>;
    /**
     * Attack magnitude can be defined by total mitigated bytes or by total mitigated
     * attacks.
     */
    magnitude?: 'MITIGATED_BYTES' | 'MITIGATED_ATTACKS';
    /**
     * Array of names used to label the series in the response.
     */
    name?: Array<string>;
    /**
     * Normalization method applied. Refer to
     * [Normalization methods](https://developers.cloudflare.com/radar/concepts/normalization/).
     */
    normalization?: 'PERCENTAGE' | 'MIN_MAX';
    /**
     * Array of L3/4 attack types.
     */
    protocol?: Array<'UDP' | 'TCP' | 'ICMP' | 'GRE'>;
}
export interface TopIndustryParams {
    /**
     * Comma-separated list of continents (alpha-2 continent codes). Prefix with `-` to
     * exclude continents from results. For example, `-EU,NA` excludes results from EU,
     * but includes results from NA.
     */
    continent?: Array<string>;
    /**
     * End of the date range (inclusive).
     */
    dateEnd?: Array<string>;
    /**
     * Filters results by the specified date range. For example, use `7d` and
     * `7dcontrol` to compare this week with the previous week. Use this parameter or
     * set specific start and end dates (`dateStart` and `dateEnd` parameters).
     */
    dateRange?: Array<string>;
    /**
     * Start of the date range.
     */
    dateStart?: Array<string>;
    /**
     * Format in which results will be returned.
     */
    format?: 'JSON' | 'CSV';
    /**
     * Filters results by IP version (Ipv4 vs. IPv6).
     */
    ipVersion?: Array<'IPv4' | 'IPv6'>;
    /**
     * Limits the number of objects returned in the response.
     */
    limit?: number;
    /**
     * Comma-separated list of locations (alpha-2 codes). Prefix with `-` to exclude
     * locations from results. For example, `-US,PT` excludes results from the US, but
     * includes results from PT.
     */
    location?: Array<string>;
    /**
     * Array of names used to label the series in the response.
     */
    name?: Array<string>;
    /**
     * Array of L3/4 attack types.
     */
    protocol?: Array<'UDP' | 'TCP' | 'ICMP' | 'GRE'>;
}
export interface TopVerticalParams {
    /**
     * Comma-separated list of continents (alpha-2 continent codes). Prefix with `-` to
     * exclude continents from results. For example, `-EU,NA` excludes results from EU,
     * but includes results from NA.
     */
    continent?: Array<string>;
    /**
     * End of the date range (inclusive).
     */
    dateEnd?: Array<string>;
    /**
     * Filters results by the specified date range. For example, use `7d` and
     * `7dcontrol` to compare this week with the previous week. Use this parameter or
     * set specific start and end dates (`dateStart` and `dateEnd` parameters).
     */
    dateRange?: Array<string>;
    /**
     * Start of the date range.
     */
    dateStart?: Array<string>;
    /**
     * Format in which results will be returned.
     */
    format?: 'JSON' | 'CSV';
    /**
     * Filters results by IP version (Ipv4 vs. IPv6).
     */
    ipVersion?: Array<'IPv4' | 'IPv6'>;
    /**
     * Limits the number of objects returned in the response.
     */
    limit?: number;
    /**
     * Comma-separated list of locations (alpha-2 codes). Prefix with `-` to exclude
     * locations from results. For example, `-US,PT` excludes results from the US, but
     * includes results from PT.
     */
    location?: Array<string>;
    /**
     * Array of names used to label the series in the response.
     */
    name?: Array<string>;
    /**
     * Array of L3/4 attack types.
     */
    protocol?: Array<'UDP' | 'TCP' | 'ICMP' | 'GRE'>;
}
export declare namespace Top {
    export { type TopAttacksResponse as TopAttacksResponse, type TopIndustryResponse as TopIndustryResponse, type TopVerticalResponse as TopVerticalResponse, type TopAttacksParams as TopAttacksParams, type TopIndustryParams as TopIndustryParams, type TopVerticalParams as TopVerticalParams, };
    export { Locations as Locations, type LocationOriginResponse as LocationOriginResponse, type LocationTargetResponse as LocationTargetResponse, type LocationOriginParams as LocationOriginParams, type LocationTargetParams as LocationTargetParams, };
}
//# sourceMappingURL=top.d.ts.map