import { APIResource } from "../../../../../resource.js";
import * as Core from "../../../../../core.js";
export declare class Ases extends APIResource {
    /**
     * Retrieves the top origin autonomous systems of layer 7 attacks. Values are
     * percentages of the total layer 7 attacks, with the origin autonomous systems
     * determined by the client IP address.
     */
    origin(query?: AseOriginParams, options?: Core.RequestOptions): Core.APIPromise<AseOriginResponse>;
    origin(options?: Core.RequestOptions): Core.APIPromise<AseOriginResponse>;
}
export interface AseOriginResponse {
    meta: AseOriginResponse.Meta;
    top_0: Array<AseOriginResponse.Top0>;
}
export declare namespace AseOriginResponse {
    interface Meta {
        dateRange: Array<Meta.DateRange>;
        lastUpdated: string;
        confidenceInfo?: Meta.ConfidenceInfo;
    }
    namespace Meta {
        interface DateRange {
            /**
             * Adjusted end of date range.
             */
            endTime: string;
            /**
             * Adjusted start of date range.
             */
            startTime: string;
        }
        interface ConfidenceInfo {
            annotations?: Array<ConfidenceInfo.Annotation>;
            level?: number;
        }
        namespace ConfidenceInfo {
            interface Annotation {
                dataSource: string;
                description: string;
                eventType: string;
                isInstantaneous: boolean;
                endTime?: string;
                linkedUrl?: string;
                startTime?: string;
            }
        }
    }
    interface Top0 {
        originAsn: string;
        originAsnName: string;
        rank: number;
        value: string;
    }
}
export interface AseOriginParams {
    /**
     * Comma-separated list of continents (alpha-2 continent codes). Prefix with `-` to
     * exclude continents from results. For example, `-EU,NA` excludes results from EU,
     * but includes results from NA.
     */
    continent?: Array<string>;
    /**
     * End of the date range (inclusive).
     */
    dateEnd?: Array<string>;
    /**
     * Filters results by the specified date range. For example, use `7d` and
     * `7dcontrol` to compare this week with the previous week. Use this parameter or
     * set specific start and end dates (`dateStart` and `dateEnd` parameters).
     */
    dateRange?: Array<string>;
    /**
     * Start of the date range.
     */
    dateStart?: Array<string>;
    /**
     * Format in which results will be returned.
     */
    format?: 'JSON' | 'CSV';
    /**
     * Filters results by HTTP method.
     */
    httpMethod?: Array<'GET' | 'POST' | 'DELETE' | 'PUT' | 'HEAD' | 'PURGE' | 'OPTIONS' | 'PROPFIND' | 'MKCOL' | 'PATCH' | 'ACL' | 'BCOPY' | 'BDELETE' | 'BMOVE' | 'BPROPFIND' | 'BPROPPATCH' | 'CHECKIN' | 'CHECKOUT' | 'CONNECT' | 'COPY' | 'LABEL' | 'LOCK' | 'MERGE' | 'MKACTIVITY' | 'MKWORKSPACE' | 'MOVE' | 'NOTIFY' | 'ORDERPATCH' | 'POLL' | 'PROPPATCH' | 'REPORT' | 'SEARCH' | 'SUBSCRIBE' | 'TRACE' | 'UNCHECKOUT' | 'UNLOCK' | 'UNSUBSCRIBE' | 'UPDATE' | 'VERSIONCONTROL' | 'BASELINECONTROL' | 'XMSENUMATTS' | 'RPC_OUT_DATA' | 'RPC_IN_DATA' | 'JSON' | 'COOK' | 'TRACK'>;
    /**
     * Filters results by HTTP version.
     */
    httpVersion?: Array<'HTTPv1' | 'HTTPv2' | 'HTTPv3'>;
    /**
     * Filters results by IP version (Ipv4 vs. IPv6).
     */
    ipVersion?: Array<'IPv4' | 'IPv6'>;
    /**
     * Limits the number of objects returned in the response.
     */
    limit?: number;
    /**
     * Comma-separated list of locations (alpha-2 codes). Prefix with `-` to exclude
     * locations from results. For example, `-US,PT` excludes results from the US, but
     * includes results from PT.
     */
    location?: Array<string>;
    /**
     * Array of L7 mitigation products.
     */
    mitigationProduct?: Array<'DDOS' | 'WAF' | 'BOT_MANAGEMENT' | 'ACCESS_RULES' | 'IP_REPUTATION' | 'API_SHIELD' | 'DATA_LOSS_PREVENTION'>;
    /**
     * Array of names used to label the series in the response.
     */
    name?: Array<string>;
}
export declare namespace Ases {
    export { type AseOriginResponse as AseOriginResponse, type AseOriginParams as AseOriginParams };
}
//# sourceMappingURL=ases.d.ts.map