import { APIResource } from "../../../resource.js";
import * as Core from "../../../core.js";
export declare class Routes extends APIResource {
    /**
     * Retrieves all ASes in the current global routing tables with routing statistics.
     */
    ases(query?: RouteAsesParams, options?: Core.RequestOptions): Core.APIPromise<RouteAsesResponse>;
    ases(options?: Core.RequestOptions): Core.APIPromise<RouteAsesResponse>;
    /**
     * Retrieves all Multi-Origin AS (MOAS) prefixes in the global routing tables.
     */
    moas(query?: RouteMoasParams, options?: Core.RequestOptions): Core.APIPromise<RouteMoasResponse>;
    moas(options?: Core.RequestOptions): Core.APIPromise<RouteMoasResponse>;
    /**
     * Retrieves the prefix-to-ASN mapping from global routing tables.
     */
    pfx2as(query?: RoutePfx2asParams, options?: Core.RequestOptions): Core.APIPromise<RoutePfx2asResponse>;
    pfx2as(options?: Core.RequestOptions): Core.APIPromise<RoutePfx2asResponse>;
    /**
     * Retrieves the BGP routing table stats.
     */
    stats(query?: RouteStatsParams, options?: Core.RequestOptions): Core.APIPromise<RouteStatsResponse>;
    stats(options?: Core.RequestOptions): Core.APIPromise<RouteStatsResponse>;
}
export interface RouteAsesResponse {
    asns: Array<RouteAsesResponse.ASN>;
    meta: RouteAsesResponse.Meta;
}
export declare namespace RouteAsesResponse {
    interface ASN {
        asn: number;
        /**
         * AS's customer cone size
         */
        coneSize: number;
        /**
         * 2-letter country code for the AS's registration country
         */
        country: string;
        /**
         * number of IPv4 addresses originated by the AS
         */
        ipv4Count: number;
        /**
         * number of IPv6 addresses originated by the AS
         */
        ipv6Count: string;
        /**
         * name of the AS
         */
        name: string;
        /**
         * number of total IP prefixes originated by the AS
         */
        pfxsCount: number;
        /**
         * number of RPKI invalid prefixes originated by the AS
         */
        rpkiInvalid: number;
        /**
         * number of RPKI unknown prefixes originated by the AS
         */
        rpkiUnknown: number;
        /**
         * number of RPKI valid prefixes originated by the AS
         */
        rpkiValid: number;
    }
    interface Meta {
        /**
         * the timestamp of when the data is generated
         */
        dataTime: string;
        /**
         * the timestamp of the query
         */
        queryTime: string;
        /**
         * total number of route collector peers used to generate this data
         */
        totalPeers: number;
    }
}
export interface RouteMoasResponse {
    meta: RouteMoasResponse.Meta;
    moas: Array<RouteMoasResponse.Moa>;
}
export declare namespace RouteMoasResponse {
    interface Meta {
        data_time: string;
        query_time: string;
        total_peers: number;
    }
    interface Moa {
        origins: Array<Moa.Origin>;
        prefix: string;
    }
    namespace Moa {
        interface Origin {
            origin: number;
            peer_count: number;
            rpki_validation: string;
        }
    }
}
export interface RoutePfx2asResponse {
    meta: RoutePfx2asResponse.Meta;
    prefix_origins: Array<RoutePfx2asResponse.PrefixOrigin>;
}
export declare namespace RoutePfx2asResponse {
    interface Meta {
        data_time: string;
        query_time: string;
        total_peers: number;
    }
    interface PrefixOrigin {
        origin: number;
        peer_count: number;
        prefix: string;
        rpki_validation: string;
    }
}
export interface RouteStatsResponse {
    meta: RouteStatsResponse.Meta;
    stats: RouteStatsResponse.Stats;
}
export declare namespace RouteStatsResponse {
    interface Meta {
        data_time: string;
        query_time: string;
        total_peers: number;
    }
    interface Stats {
        distinct_origins: number;
        distinct_origins_ipv4: number;
        distinct_origins_ipv6: number;
        distinct_prefixes: number;
        distinct_prefixes_ipv4: number;
        distinct_prefixes_ipv6: number;
        routes_invalid: number;
        routes_invalid_ipv4: number;
        routes_invalid_ipv6: number;
        routes_total: number;
        routes_total_ipv4: number;
        routes_total_ipv6: number;
        routes_unknown: number;
        routes_unknown_ipv4: number;
        routes_unknown_ipv6: number;
        routes_valid: number;
        routes_valid_ipv4: number;
        routes_valid_ipv6: number;
    }
}
export interface RouteAsesParams {
    /**
     * Format in which results will be returned.
     */
    format?: 'JSON' | 'CSV';
    /**
     * Limits the number of objects returned in the response.
     */
    limit?: number;
    /**
     * Location alpha-2 code.
     */
    location?: string;
    /**
     * Sorts results by the specified field.
     */
    sortBy?: 'cone' | 'pfxs' | 'ipv4' | 'ipv6' | 'rpki_valid' | 'rpki_invalid' | 'rpki_unknown';
    /**
     * Sort order.
     */
    sortOrder?: 'ASC' | 'DESC';
}
export interface RouteMoasParams {
    /**
     * Format in which results will be returned.
     */
    format?: 'JSON' | 'CSV';
    /**
     * Lookup only RPKI invalid MOASes.
     */
    invalid_only?: boolean;
    /**
     * Lookup MOASes originated by the given ASN.
     */
    origin?: number;
    /**
     * Network prefix, IPv4 or IPv6.
     */
    prefix?: string;
}
export interface RoutePfx2asParams {
    /**
     * Format in which results will be returned.
     */
    format?: 'JSON' | 'CSV';
    /**
     * Return only results with the longest prefix match for the given prefix. For
     * example, specify a /32 prefix to lookup the origin ASN for an IPv4 address.
     */
    longestPrefixMatch?: boolean;
    /**
     * Lookup prefixes originated by the given ASN.
     */
    origin?: number;
    /**
     * Network prefix, IPv4 or IPv6.
     */
    prefix?: string;
    /**
     * Return only results with matching rpki status: valid, invalid or unknown.
     */
    rpkiStatus?: 'VALID' | 'INVALID' | 'UNKNOWN';
}
export interface RouteStatsParams {
    /**
     * Single Autonomous System Number (ASN) as integer.
     */
    asn?: number;
    /**
     * Format in which results will be returned.
     */
    format?: 'JSON' | 'CSV';
    /**
     * Location alpha-2 code.
     */
    location?: string;
}
export declare namespace Routes {
    export { type RouteAsesResponse as RouteAsesResponse, type RouteMoasResponse as RouteMoasResponse, type RoutePfx2asResponse as RoutePfx2asResponse, type RouteStatsResponse as RouteStatsResponse, type RouteAsesParams as RouteAsesParams, type RouteMoasParams as RouteMoasParams, type RoutePfx2asParams as RoutePfx2asParams, type RouteStatsParams as RouteStatsParams, };
}
//# sourceMappingURL=routes.d.ts.map