import { APIResource } from "../../../resource.js";
import * as Core from "../../../core.js";
export declare class Summary extends APIResource {
    /**
     * Retrieves the distribution of HTTP authentication requests by bot class.
     */
    botClass(query?: SummaryBotClassParams, options?: Core.RequestOptions): Core.APIPromise<SummaryBotClassResponse>;
    botClass(options?: Core.RequestOptions): Core.APIPromise<SummaryBotClassResponse>;
    /**
     * Retrieves the distribution of HTTP authentication requests by compromised
     * credential status.
     */
    compromised(query?: SummaryCompromisedParams, options?: Core.RequestOptions): Core.APIPromise<SummaryCompromisedResponse>;
    compromised(options?: Core.RequestOptions): Core.APIPromise<SummaryCompromisedResponse>;
}
export interface SummaryBotClassResponse {
    meta: SummaryBotClassResponse.Meta;
    summary_0: SummaryBotClassResponse.Summary0;
}
export declare namespace SummaryBotClassResponse {
    interface Meta {
        dateRange: Array<Meta.DateRange>;
        lastUpdated: string;
        normalization: string;
        confidenceInfo?: Meta.ConfidenceInfo;
    }
    namespace Meta {
        interface DateRange {
            /**
             * Adjusted end of date range.
             */
            endTime: string;
            /**
             * Adjusted start of date range.
             */
            startTime: string;
        }
        interface ConfidenceInfo {
            annotations?: Array<ConfidenceInfo.Annotation>;
            level?: number;
        }
        namespace ConfidenceInfo {
            interface Annotation {
                dataSource: string;
                description: string;
                eventType: string;
                isInstantaneous: boolean;
                endTime?: string;
                linkedUrl?: string;
                startTime?: string;
            }
        }
    }
    interface Summary0 {
        bot: string;
        human: string;
    }
}
export interface SummaryCompromisedResponse {
    meta: SummaryCompromisedResponse.Meta;
    summary_0: SummaryCompromisedResponse.Summary0;
}
export declare namespace SummaryCompromisedResponse {
    interface Meta {
        dateRange: Array<Meta.DateRange>;
        lastUpdated: string;
        normalization: string;
        confidenceInfo?: Meta.ConfidenceInfo;
    }
    namespace Meta {
        interface DateRange {
            /**
             * Adjusted end of date range.
             */
            endTime: string;
            /**
             * Adjusted start of date range.
             */
            startTime: string;
        }
        interface ConfidenceInfo {
            annotations?: Array<ConfidenceInfo.Annotation>;
            level?: number;
        }
        namespace ConfidenceInfo {
            interface Annotation {
                dataSource: string;
                description: string;
                eventType: string;
                isInstantaneous: boolean;
                endTime?: string;
                linkedUrl?: string;
                startTime?: string;
            }
        }
    }
    interface Summary0 {
        CLEAN: string;
        COMPROMISED: string;
    }
}
export interface SummaryBotClassParams {
    /**
     * Filters results by compromised credential status (clean vs. compromised).
     */
    compromised?: Array<'CLEAN' | 'COMPROMISED'>;
    /**
     * End of the date range (inclusive).
     */
    dateEnd?: Array<string>;
    /**
     * Filters results by the specified date range. For example, use `7d` and
     * `7dcontrol` to compare this week with the previous week. Use this parameter or
     * set specific start and end dates (`dateStart` and `dateEnd` parameters).
     */
    dateRange?: Array<string>;
    /**
     * Start of the date range.
     */
    dateStart?: Array<string>;
    /**
     * Format in which results will be returned.
     */
    format?: 'JSON' | 'CSV';
    /**
     * Array of names used to label the series in the response.
     */
    name?: Array<string>;
}
export interface SummaryCompromisedParams {
    /**
     * Filters results by bot class. Refer to
     * [Bot classes](https://developers.cloudflare.com/radar/concepts/bot-classes/).
     */
    botClass?: Array<'LIKELY_AUTOMATED' | 'LIKELY_HUMAN'>;
    /**
     * End of the date range (inclusive).
     */
    dateEnd?: Array<string>;
    /**
     * Filters results by the specified date range. For example, use `7d` and
     * `7dcontrol` to compare this week with the previous week. Use this parameter or
     * set specific start and end dates (`dateStart` and `dateEnd` parameters).
     */
    dateRange?: Array<string>;
    /**
     * Start of the date range.
     */
    dateStart?: Array<string>;
    /**
     * Format in which results will be returned.
     */
    format?: 'JSON' | 'CSV';
    /**
     * Array of names used to label the series in the response.
     */
    name?: Array<string>;
}
export declare namespace Summary {
    export { type SummaryBotClassResponse as SummaryBotClassResponse, type SummaryCompromisedResponse as SummaryCompromisedResponse, type SummaryBotClassParams as SummaryBotClassParams, type SummaryCompromisedParams as SummaryCompromisedParams, };
}
//# sourceMappingURL=summary.d.ts.map