import { APIResource } from "../../resource.js";
import * as DatasetsAPI from "./datasets.js";
import { DatasetDownloadParams, DatasetDownloadResponse, DatasetGetResponse, DatasetListParams, DatasetListResponse, Datasets } from "./datasets.js";
import * as SearchAPI from "./search.js";
import { Search, SearchGlobalParams, SearchGlobalResponse } from "./search.js";
import * as TCPResetsTimeoutsAPI from "./tcp-resets-timeouts.js";
import { TCPResetsTimeoutSummaryParams, TCPResetsTimeoutSummaryResponse, TCPResetsTimeoutTimeseriesGroupsParams, TCPResetsTimeoutTimeseriesGroupsResponse, TCPResetsTimeouts } from "./tcp-resets-timeouts.js";
import * as AIAPI from "./ai/ai.js";
import { AI } from "./ai/ai.js";
import * as AnnotationsAPI from "./annotations/annotations.js";
import { AnnotationListParams, AnnotationListResponse, Annotations } from "./annotations/annotations.js";
import * as AS112API from "./as112/as112.js";
import { AS112, AS112TimeseriesParams, AS112TimeseriesResponse } from "./as112/as112.js";
import * as AttacksAPI from "./attacks/attacks.js";
import { Attacks } from "./attacks/attacks.js";
import * as BGPAPI from "./bgp/bgp.js";
import { BGP, BGPTimeseriesParams, BGPTimeseriesResponse } from "./bgp/bgp.js";
import * as DNSAPI from "./dns/dns.js";
import { DNS, DNSTimeseriesParams, DNSTimeseriesResponse } from "./dns/dns.js";
import * as EmailAPI from "./email/email.js";
import { Email, RadarEmailSeries, RadarEmailSummary } from "./email/email.js";
import * as EntitiesAPI from "./entities/entities.js";
import { Entities, EntityGetParams, EntityGetResponse } from "./entities/entities.js";
import * as HTTPAPI from "./http/http.js";
import { HTTP, HTTPTimeseriesParams, HTTPTimeseriesResponse } from "./http/http.js";
import * as LeakedCredentialsAPI from "./leaked-credentials/leaked-credentials.js";
import { LeakedCredentials } from "./leaked-credentials/leaked-credentials.js";
import * as NetflowsAPI from "./netflows/netflows.js";
import { NetflowSummaryParams, NetflowSummaryResponse, NetflowTimeseriesParams, NetflowTimeseriesResponse, Netflows } from "./netflows/netflows.js";
import * as QualityAPI from "./quality/quality.js";
import { Quality } from "./quality/quality.js";
import * as RankingAPI from "./ranking/ranking.js";
import { Ranking, RankingTimeseriesGroupsParams, RankingTimeseriesGroupsResponse, RankingTopParams, RankingTopResponse } from "./ranking/ranking.js";
import * as RobotsTXTAPI from "./robots-txt/robots-txt.js";
import { RobotsTXT } from "./robots-txt/robots-txt.js";
import * as TrafficAnomaliesAPI from "./traffic-anomalies/traffic-anomalies.js";
import { TrafficAnomalies, TrafficAnomalyGetParams, TrafficAnomalyGetResponse } from "./traffic-anomalies/traffic-anomalies.js";
import * as VerifiedBotsAPI from "./verified-bots/verified-bots.js";
import { VerifiedBots } from "./verified-bots/verified-bots.js";
export declare class Radar extends APIResource {
    ai: AIAPI.AI;
    annotations: AnnotationsAPI.Annotations;
    bgp: BGPAPI.BGP;
    datasets: DatasetsAPI.Datasets;
    dns: DNSAPI.DNS;
    netflows: NetflowsAPI.Netflows;
    search: SearchAPI.Search;
    verifiedBots: VerifiedBotsAPI.VerifiedBots;
    as112: AS112API.AS112;
    email: EmailAPI.Email;
    attacks: AttacksAPI.Attacks;
    entities: EntitiesAPI.Entities;
    http: HTTPAPI.HTTP;
    quality: QualityAPI.Quality;
    ranking: RankingAPI.Ranking;
    trafficAnomalies: TrafficAnomaliesAPI.TrafficAnomalies;
    tcpResetsTimeouts: TCPResetsTimeoutsAPI.TCPResetsTimeouts;
    robotsTXT: RobotsTXTAPI.RobotsTXT;
    leakedCredentials: LeakedCredentialsAPI.LeakedCredentials;
}
export declare namespace Radar {
    export { AI as AI };
    export { Annotations as Annotations, type AnnotationListResponse as AnnotationListResponse, type AnnotationListParams as AnnotationListParams, };
    export { BGP as BGP, type BGPTimeseriesResponse as BGPTimeseriesResponse, type BGPTimeseriesParams as BGPTimeseriesParams, };
    export { Datasets as Datasets, type DatasetListResponse as DatasetListResponse, type DatasetDownloadResponse as DatasetDownloadResponse, type DatasetGetResponse as DatasetGetResponse, type DatasetListParams as DatasetListParams, type DatasetDownloadParams as DatasetDownloadParams, };
    export { DNS as DNS, type DNSTimeseriesResponse as DNSTimeseriesResponse, type DNSTimeseriesParams as DNSTimeseriesParams, };
    export { Netflows as Netflows, type NetflowSummaryResponse as NetflowSummaryResponse, type NetflowTimeseriesResponse as NetflowTimeseriesResponse, type NetflowSummaryParams as NetflowSummaryParams, type NetflowTimeseriesParams as NetflowTimeseriesParams, };
    export { Search as Search, type SearchGlobalResponse as SearchGlobalResponse, type SearchGlobalParams as SearchGlobalParams, };
    export { VerifiedBots as VerifiedBots };
    export { AS112 as AS112, type AS112TimeseriesResponse as AS112TimeseriesResponse, type AS112TimeseriesParams as AS112TimeseriesParams, };
    export { Email as Email, type RadarEmailSeries as RadarEmailSeries, type RadarEmailSummary as RadarEmailSummary, };
    export { Attacks as Attacks };
    export { Entities as Entities, type EntityGetResponse as EntityGetResponse, type EntityGetParams as EntityGetParams, };
    export { HTTP as HTTP, type HTTPTimeseriesResponse as HTTPTimeseriesResponse, type HTTPTimeseriesParams as HTTPTimeseriesParams, };
    export { Quality as Quality };
    export { Ranking as Ranking, type RankingTimeseriesGroupsResponse as RankingTimeseriesGroupsResponse, type RankingTopResponse as RankingTopResponse, type RankingTimeseriesGroupsParams as RankingTimeseriesGroupsParams, type RankingTopParams as RankingTopParams, };
    export { TrafficAnomalies as TrafficAnomalies, type TrafficAnomalyGetResponse as TrafficAnomalyGetResponse, type TrafficAnomalyGetParams as TrafficAnomalyGetParams, };
    export { TCPResetsTimeouts as TCPResetsTimeouts, type TCPResetsTimeoutSummaryResponse as TCPResetsTimeoutSummaryResponse, type TCPResetsTimeoutTimeseriesGroupsResponse as TCPResetsTimeoutTimeseriesGroupsResponse, type TCPResetsTimeoutSummaryParams as TCPResetsTimeoutSummaryParams, type TCPResetsTimeoutTimeseriesGroupsParams as TCPResetsTimeoutTimeseriesGroupsParams, };
    export { RobotsTXT as RobotsTXT };
    export { LeakedCredentials as LeakedCredentials };
}
//# sourceMappingURL=radar.d.ts.map