// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../resource.mjs";
import * as DatasetsAPI from "./datasets.mjs";
import { Datasets, } from "./datasets.mjs";
import * as SearchAPI from "./search.mjs";
import { Search } from "./search.mjs";
import * as TCPResetsTimeoutsAPI from "./tcp-resets-timeouts.mjs";
import { TCPResetsTimeouts, } from "./tcp-resets-timeouts.mjs";
import * as AIAPI from "./ai/ai.mjs";
import { AI } from "./ai/ai.mjs";
import * as AnnotationsAPI from "./annotations/annotations.mjs";
import { Annotations } from "./annotations/annotations.mjs";
import * as AS112API from "./as112/as112.mjs";
import { AS112 } from "./as112/as112.mjs";
import * as AttacksAPI from "./attacks/attacks.mjs";
import { Attacks } from "./attacks/attacks.mjs";
import * as BGPAPI from "./bgp/bgp.mjs";
import { BGP } from "./bgp/bgp.mjs";
import * as DNSAPI from "./dns/dns.mjs";
import { DNS } from "./dns/dns.mjs";
import * as EmailAPI from "./email/email.mjs";
import { Email } from "./email/email.mjs";
import * as EntitiesAPI from "./entities/entities.mjs";
import { Entities } from "./entities/entities.mjs";
import * as HTTPAPI from "./http/http.mjs";
import { HTTP } from "./http/http.mjs";
import * as LeakedCredentialsAPI from "./leaked-credentials/leaked-credentials.mjs";
import { LeakedCredentials } from "./leaked-credentials/leaked-credentials.mjs";
import * as NetflowsAPI from "./netflows/netflows.mjs";
import { Netflows, } from "./netflows/netflows.mjs";
import * as QualityAPI from "./quality/quality.mjs";
import { Quality } from "./quality/quality.mjs";
import * as RankingAPI from "./ranking/ranking.mjs";
import { Ranking, } from "./ranking/ranking.mjs";
import * as RobotsTXTAPI from "./robots-txt/robots-txt.mjs";
import { RobotsTXT } from "./robots-txt/robots-txt.mjs";
import * as TrafficAnomaliesAPI from "./traffic-anomalies/traffic-anomalies.mjs";
import { TrafficAnomalies, } from "./traffic-anomalies/traffic-anomalies.mjs";
import * as VerifiedBotsAPI from "./verified-bots/verified-bots.mjs";
import { VerifiedBots } from "./verified-bots/verified-bots.mjs";
export class Radar extends APIResource {
    constructor() {
        super(...arguments);
        this.ai = new AIAPI.AI(this._client);
        this.annotations = new AnnotationsAPI.Annotations(this._client);
        this.bgp = new BGPAPI.BGP(this._client);
        this.datasets = new DatasetsAPI.Datasets(this._client);
        this.dns = new DNSAPI.DNS(this._client);
        this.netflows = new NetflowsAPI.Netflows(this._client);
        this.search = new SearchAPI.Search(this._client);
        this.verifiedBots = new VerifiedBotsAPI.VerifiedBots(this._client);
        this.as112 = new AS112API.AS112(this._client);
        this.email = new EmailAPI.Email(this._client);
        this.attacks = new AttacksAPI.Attacks(this._client);
        this.entities = new EntitiesAPI.Entities(this._client);
        this.http = new HTTPAPI.HTTP(this._client);
        this.quality = new QualityAPI.Quality(this._client);
        this.ranking = new RankingAPI.Ranking(this._client);
        this.trafficAnomalies = new TrafficAnomaliesAPI.TrafficAnomalies(this._client);
        this.tcpResetsTimeouts = new TCPResetsTimeoutsAPI.TCPResetsTimeouts(this._client);
        this.robotsTXT = new RobotsTXTAPI.RobotsTXT(this._client);
        this.leakedCredentials = new LeakedCredentialsAPI.LeakedCredentials(this._client);
    }
}
Radar.AI = AI;
Radar.Annotations = Annotations;
Radar.BGP = BGP;
Radar.Datasets = Datasets;
Radar.DNS = DNS;
Radar.Netflows = Netflows;
Radar.Search = Search;
Radar.VerifiedBots = VerifiedBots;
Radar.AS112 = AS112;
Radar.Email = Email;
Radar.Attacks = Attacks;
Radar.Entities = Entities;
Radar.HTTP = HTTP;
Radar.Quality = Quality;
Radar.Ranking = Ranking;
Radar.TrafficAnomalies = TrafficAnomalies;
Radar.TCPResetsTimeouts = TCPResetsTimeouts;
Radar.RobotsTXT = RobotsTXT;
Radar.LeakedCredentials = LeakedCredentials;
//# sourceMappingURL=radar.mjs.map