import { APIResource } from "../../../resource.js";
import * as Core from "../../../core.js";
export declare class InternetServices extends APIResource {
    /**
     * Retrieves the list of Internet services categories.
     */
    categories(query?: InternetServiceCategoriesParams, options?: Core.RequestOptions): Core.APIPromise<InternetServiceCategoriesResponse>;
    categories(options?: Core.RequestOptions): Core.APIPromise<InternetServiceCategoriesResponse>;
    /**
     * Retrieves Internet Services rank update changes over time.
     */
    timeseriesGroups(query?: InternetServiceTimeseriesGroupsParams, options?: Core.RequestOptions): Core.APIPromise<InternetServiceTimeseriesGroupsResponse>;
    timeseriesGroups(options?: Core.RequestOptions): Core.APIPromise<InternetServiceTimeseriesGroupsResponse>;
    /**
     * Retrieves top Internet services based on their rank.
     */
    top(query?: InternetServiceTopParams, options?: Core.RequestOptions): Core.APIPromise<InternetServiceTopResponse>;
    top(options?: Core.RequestOptions): Core.APIPromise<InternetServiceTopResponse>;
}
export interface InternetServiceCategoriesResponse {
    categories_0: Array<InternetServiceCategoriesResponse.Categories0>;
}
export declare namespace InternetServiceCategoriesResponse {
    interface Categories0 {
        name: string;
    }
}
export interface InternetServiceTimeseriesGroupsResponse {
    meta: InternetServiceTimeseriesGroupsResponse.Meta;
    serie_0: InternetServiceTimeseriesGroupsResponse.Serie0;
}
export declare namespace InternetServiceTimeseriesGroupsResponse {
    interface Meta {
        dateRange: Array<Meta.DateRange>;
    }
    namespace Meta {
        interface DateRange {
            /**
             * Adjusted end of date range.
             */
            endTime: string;
            /**
             * Adjusted start of date range.
             */
            startTime: string;
        }
    }
    interface Serie0 {
        timestamps: Array<string>;
        [k: string]: Array<string | number> | Array<string> | undefined;
    }
}
export interface InternetServiceTopResponse {
    meta: InternetServiceTopResponse.Meta;
    top_0: Array<InternetServiceTopResponse.Top0>;
}
export declare namespace InternetServiceTopResponse {
    interface Meta {
        top_0: Meta.Top0;
    }
    namespace Meta {
        interface Top0 {
            date: string;
            serviceCategory: string;
        }
    }
    interface Top0 {
        rank: number;
        service: string;
    }
}
export interface InternetServiceCategoriesParams {
    /**
     * Array of dates to filter the results.
     */
    date?: Array<string>;
    /**
     * Format in which results will be returned.
     */
    format?: 'JSON' | 'CSV';
    /**
     * Limits the number of objects returned in the response.
     */
    limit?: number;
    /**
     * Array of names used to label the series in the response.
     */
    name?: Array<string>;
}
export interface InternetServiceTimeseriesGroupsParams {
    /**
     * End of the date range (inclusive).
     */
    dateEnd?: Array<string>;
    /**
     * Filters results by the specified date range. For example, use `7d` and
     * `7dcontrol` to compare this week with the previous week. Use this parameter or
     * set specific start and end dates (`dateStart` and `dateEnd` parameters).
     */
    dateRange?: Array<string>;
    /**
     * Start of the date range.
     */
    dateStart?: Array<string>;
    /**
     * Format in which results will be returned.
     */
    format?: 'JSON' | 'CSV';
    /**
     * Limits the number of objects returned in the response.
     */
    limit?: number;
    /**
     * Array of names used to label the series in the response.
     */
    name?: Array<string>;
    /**
     * Filters results by Internet service category.
     */
    serviceCategory?: Array<string>;
}
export interface InternetServiceTopParams {
    /**
     * Array of dates to filter the results.
     */
    date?: Array<string>;
    /**
     * Format in which results will be returned.
     */
    format?: 'JSON' | 'CSV';
    /**
     * Limits the number of objects returned in the response.
     */
    limit?: number;
    /**
     * Array of names used to label the series in the response.
     */
    name?: Array<string>;
    /**
     * Filters results by Internet service category.
     */
    serviceCategory?: Array<string>;
}
export declare namespace InternetServices {
    export { type InternetServiceCategoriesResponse as InternetServiceCategoriesResponse, type InternetServiceTimeseriesGroupsResponse as InternetServiceTimeseriesGroupsResponse, type InternetServiceTopResponse as InternetServiceTopResponse, type InternetServiceCategoriesParams as InternetServiceCategoriesParams, type InternetServiceTimeseriesGroupsParams as InternetServiceTimeseriesGroupsParams, type InternetServiceTopParams as InternetServiceTopParams, };
}
//# sourceMappingURL=internet-services.d.ts.map