import { APIResource } from "../../../../resource.js";
import * as Core from "../../../../core.js";
import * as UserAgentsAPI from "./user-agents.js";
import { UserAgentDirectiveParams, UserAgentDirectiveResponse, UserAgents } from "./user-agents.js";
export declare class Top extends APIResource {
    userAgents: UserAgentsAPI.UserAgents;
    /**
     * Retrieves the top domain categories by the number of robots.txt files parsed.
     */
    domainCategories(query?: TopDomainCategoriesParams, options?: Core.RequestOptions): Core.APIPromise<TopDomainCategoriesResponse>;
    domainCategories(options?: Core.RequestOptions): Core.APIPromise<TopDomainCategoriesResponse>;
}
export interface TopDomainCategoriesResponse {
    meta: TopDomainCategoriesResponse.Meta;
    top_0: Array<TopDomainCategoriesResponse.Top0>;
}
export declare namespace TopDomainCategoriesResponse {
    interface Meta {
        dateRange: Array<Meta.DateRange>;
        lastUpdated: string;
        normalization: string;
        confidenceInfo?: Meta.ConfidenceInfo;
        units?: Array<Meta.Unit>;
    }
    namespace Meta {
        interface DateRange {
            /**
             * Adjusted end of date range.
             */
            endTime: string;
            /**
             * Adjusted start of date range.
             */
            startTime: string;
        }
        interface ConfidenceInfo {
            annotations?: Array<ConfidenceInfo.Annotation>;
            level?: number;
        }
        namespace ConfidenceInfo {
            interface Annotation {
                dataSource: string;
                description: string;
                eventType: string;
                isInstantaneous: boolean;
                endTime?: string;
                linkedUrl?: string;
                startTime?: string;
            }
        }
        interface Unit {
            name: string;
            value: string;
        }
    }
    interface Top0 {
        name: string;
        value: number;
    }
}
export interface TopDomainCategoriesParams {
    /**
     * Array of dates to filter the results.
     */
    date?: Array<string>;
    /**
     * Format in which results will be returned.
     */
    format?: 'JSON' | 'CSV';
    /**
     * Limits the number of objects returned in the response.
     */
    limit?: number;
    /**
     * Array of names used to label the series in the response.
     */
    name?: Array<string>;
    /**
     * Filters results by user agent category.
     */
    userAgentCategory?: 'AI';
}
export declare namespace Top {
    export { type TopDomainCategoriesResponse as TopDomainCategoriesResponse, type TopDomainCategoriesParams as TopDomainCategoriesParams, };
    export { UserAgents as UserAgents, type UserAgentDirectiveResponse as UserAgentDirectiveResponse, type UserAgentDirectiveParams as UserAgentDirectiveParams, };
}
//# sourceMappingURL=top.d.ts.map