import { APIResource } from "../../../resource.js";
import * as Core from "../../../core.js";
export declare class Top extends APIResource {
    /**
     * Retrieves the top verified bots by HTTP requests, with owner and category.
     */
    bots(query?: TopBotsParams, options?: Core.RequestOptions): Core.APIPromise<TopBotsResponse>;
    bots(options?: Core.RequestOptions): Core.APIPromise<TopBotsResponse>;
    /**
     * Retrieves the top verified bot categories by HTTP requests, along with their
     * corresponding percentage, over the total verified bot HTTP requests.
     */
    categories(query?: TopCategoriesParams, options?: Core.RequestOptions): Core.APIPromise<TopCategoriesResponse>;
    categories(options?: Core.RequestOptions): Core.APIPromise<TopCategoriesResponse>;
}
export interface TopBotsResponse {
    meta: TopBotsResponse.Meta;
    top_0: Array<TopBotsResponse.Top0>;
}
export declare namespace TopBotsResponse {
    interface Meta {
        dateRange: Array<Meta.DateRange>;
        confidenceInfo?: Meta.ConfidenceInfo;
    }
    namespace Meta {
        interface DateRange {
            /**
             * Adjusted end of date range.
             */
            endTime: string;
            /**
             * Adjusted start of date range.
             */
            startTime: string;
        }
        interface ConfidenceInfo {
            annotations?: Array<ConfidenceInfo.Annotation>;
            level?: number;
        }
        namespace ConfidenceInfo {
            interface Annotation {
                dataSource: string;
                description: string;
                eventType: string;
                isInstantaneous: boolean;
                endTime?: string;
                linkedUrl?: string;
                startTime?: string;
            }
        }
    }
    interface Top0 {
        botCategory: string;
        botName: string;
        botOwner: string;
        value: string;
    }
}
export interface TopCategoriesResponse {
    meta: TopCategoriesResponse.Meta;
    top_0: Array<TopCategoriesResponse.Top0>;
}
export declare namespace TopCategoriesResponse {
    interface Meta {
        dateRange: Array<Meta.DateRange>;
        confidenceInfo?: Meta.ConfidenceInfo;
    }
    namespace Meta {
        interface DateRange {
            /**
             * Adjusted end of date range.
             */
            endTime: string;
            /**
             * Adjusted start of date range.
             */
            startTime: string;
        }
        interface ConfidenceInfo {
            annotations?: Array<ConfidenceInfo.Annotation>;
            level?: number;
        }
        namespace ConfidenceInfo {
            interface Annotation {
                dataSource: string;
                description: string;
                eventType: string;
                isInstantaneous: boolean;
                endTime?: string;
                linkedUrl?: string;
                startTime?: string;
            }
        }
    }
    interface Top0 {
        botCategory: string;
        value: string;
    }
}
export interface TopBotsParams {
    /**
     * Comma-separated list of Autonomous System Numbers (ASNs). Prefix with `-` to
     * exclude ASNs from results. For example, `-174, 3356` excludes results from
     * AS174, but includes results from AS3356.
     */
    asn?: Array<string>;
    /**
     * Comma-separated list of continents (alpha-2 continent codes). Prefix with `-` to
     * exclude continents from results. For example, `-EU,NA` excludes results from EU,
     * but includes results from NA.
     */
    continent?: Array<string>;
    /**
     * End of the date range (inclusive).
     */
    dateEnd?: Array<string>;
    /**
     * Filters results by the specified date range. For example, use `7d` and
     * `7dcontrol` to compare this week with the previous week. Use this parameter or
     * set specific start and end dates (`dateStart` and `dateEnd` parameters).
     */
    dateRange?: Array<string>;
    /**
     * Start of the date range.
     */
    dateStart?: Array<string>;
    /**
     * Format in which results will be returned.
     */
    format?: 'JSON' | 'CSV';
    /**
     * Limits the number of objects returned in the response.
     */
    limit?: number;
    /**
     * Comma-separated list of locations (alpha-2 codes). Prefix with `-` to exclude
     * locations from results. For example, `-US,PT` excludes results from the US, but
     * includes results from PT.
     */
    location?: Array<string>;
    /**
     * Array of names used to label the series in the response.
     */
    name?: Array<string>;
}
export interface TopCategoriesParams {
    /**
     * Comma-separated list of Autonomous System Numbers (ASNs). Prefix with `-` to
     * exclude ASNs from results. For example, `-174, 3356` excludes results from
     * AS174, but includes results from AS3356.
     */
    asn?: Array<string>;
    /**
     * Comma-separated list of continents (alpha-2 continent codes). Prefix with `-` to
     * exclude continents from results. For example, `-EU,NA` excludes results from EU,
     * but includes results from NA.
     */
    continent?: Array<string>;
    /**
     * End of the date range (inclusive).
     */
    dateEnd?: Array<string>;
    /**
     * Filters results by the specified date range. For example, use `7d` and
     * `7dcontrol` to compare this week with the previous week. Use this parameter or
     * set specific start and end dates (`dateStart` and `dateEnd` parameters).
     */
    dateRange?: Array<string>;
    /**
     * Start of the date range.
     */
    dateStart?: Array<string>;
    /**
     * Format in which results will be returned.
     */
    format?: 'JSON' | 'CSV';
    /**
     * Limits the number of objects returned in the response.
     */
    limit?: number;
    /**
     * Comma-separated list of locations (alpha-2 codes). Prefix with `-` to exclude
     * locations from results. For example, `-US,PT` excludes results from the US, but
     * includes results from PT.
     */
    location?: Array<string>;
    /**
     * Array of names used to label the series in the response.
     */
    name?: Array<string>;
}
export declare namespace Top {
    export { type TopBotsResponse as TopBotsResponse, type TopCategoriesResponse as TopCategoriesResponse, type TopBotsParams as TopBotsParams, type TopCategoriesParams as TopCategoriesParams, };
}
//# sourceMappingURL=top.d.ts.map