"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.DomainsSinglePage = exports.Domains = void 0;
const resource_1 = require("../../resource.js");
const pagination_1 = require("../../pagination.js");
class Domains extends resource_1.APIResource {
    /**
     * Update individual domain.
     */
    update(domainName, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/registrar/domains/${domainName}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List domains handled by Registrar.
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/registrar/domains`, DomainsSinglePage, options);
    }
    /**
     * Show individual domain.
     */
    get(domainName, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/registrar/domains/${domainName}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.Domains = Domains;
class DomainsSinglePage extends pagination_1.SinglePage {
}
exports.DomainsSinglePage = DomainsSinglePage;
Domains.DomainsSinglePage = DomainsSinglePage;
//# sourceMappingURL=domains.js.map