// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../resource.mjs";
import { SinglePage } from "../../pagination.mjs";
export class Domains extends APIResource {
    /**
     * Update individual domain.
     */
    update(domainName, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/registrar/domains/${domainName}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List domains handled by Registrar.
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/registrar/domains`, DomainsSinglePage, options);
    }
    /**
     * Show individual domain.
     */
    get(domainName, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/registrar/domains/${domainName}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class DomainsSinglePage extends SinglePage {
}
Domains.DomainsSinglePage = DomainsSinglePage;
//# sourceMappingURL=domains.mjs.map