// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../resource.mjs";
import * as RecipientsAPI from "./recipients.mjs";
import { RecipientListResponsesV4PagePaginationArray, Recipients, } from "./recipients.mjs";
import * as ResourcesAPI from "./resources.mjs";
import { ResourceListResponsesV4PagePaginationArray, Resources, } from "./resources.mjs";
import { V4PagePaginationArray } from "../../pagination.mjs";
export class ResourceSharing extends APIResource {
    constructor() {
        super(...arguments);
        this.recipients = new RecipientsAPI.Recipients(this._client);
        this.resources = new ResourcesAPI.Resources(this._client);
    }
    /**
     * Create a new share
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/shares`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Updating is not immediate, an updated share object with a new status will be
     * returned.
     */
    update(shareId, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/shares/${shareId}`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Lists all account shares.
     */
    list(params, options) {
        const { account_id, ...query } = params;
        return this._client.getAPIList(`/accounts/${account_id}/shares`, ResourceSharingListResponsesV4PagePaginationArray, { query, ...options });
    }
    /**
     * Deletion is not immediate, an updated share object with a new status will be
     * returned.
     */
    delete(shareId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/shares/${shareId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetches share by ID.
     */
    get(shareId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/shares/${shareId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class ResourceSharingListResponsesV4PagePaginationArray extends V4PagePaginationArray {
}
ResourceSharing.Recipients = Recipients;
ResourceSharing.RecipientListResponsesV4PagePaginationArray = RecipientListResponsesV4PagePaginationArray;
ResourceSharing.Resources = Resources;
ResourceSharing.ResourceListResponsesV4PagePaginationArray = ResourceListResponsesV4PagePaginationArray;
//# sourceMappingURL=resource-sharing.mjs.map