"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResourceListResponsesV4PagePaginationArray = exports.Resources = void 0;
const resource_1 = require("../../resource.js");
const pagination_1 = require("../../pagination.js");
class Resources extends resource_1.APIResource {
    /**
     * Create a new share resource
     */
    create(shareId, params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/shares/${shareId}/resources`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Update is not immediate, an updated share resource object with a new status will
     * be returned.
     */
    update(shareId, resourceId, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/shares/${shareId}/resources/${resourceId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List share resources by share ID.
     */
    list(shareId, params, options) {
        const { account_id, ...query } = params;
        return this._client.getAPIList(`/accounts/${account_id}/shares/${shareId}/resources`, ResourceListResponsesV4PagePaginationArray, { query, ...options });
    }
    /**
     * Deletion is not immediate, an updated share resource object with a new status
     * will be returned.
     */
    delete(shareId, resourceId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/shares/${shareId}/resources/${resourceId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get share resource by ID.
     */
    get(shareId, resourceId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/shares/${shareId}/resources/${resourceId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.Resources = Resources;
class ResourceListResponsesV4PagePaginationArray extends pagination_1.V4PagePaginationArray {
}
exports.ResourceListResponsesV4PagePaginationArray = ResourceListResponsesV4PagePaginationArray;
Resources.ResourceListResponsesV4PagePaginationArray = ResourceListResponsesV4PagePaginationArray;
//# sourceMappingURL=resources.js.map