// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../resource.mjs";
import { V4PagePaginationArray } from "../../pagination.mjs";
export class Resources extends APIResource {
    /**
     * Create a new share resource
     */
    create(shareId, params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/shares/${shareId}/resources`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Update is not immediate, an updated share resource object with a new status will
     * be returned.
     */
    update(shareId, resourceId, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/shares/${shareId}/resources/${resourceId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List share resources by share ID.
     */
    list(shareId, params, options) {
        const { account_id, ...query } = params;
        return this._client.getAPIList(`/accounts/${account_id}/shares/${shareId}/resources`, ResourceListResponsesV4PagePaginationArray, { query, ...options });
    }
    /**
     * Deletion is not immediate, an updated share resource object with a new status
     * will be returned.
     */
    delete(shareId, resourceId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/shares/${shareId}/resources/${resourceId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get share resource by ID.
     */
    get(shareId, resourceId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/shares/${shareId}/resources/${resourceId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class ResourceListResponsesV4PagePaginationArray extends V4PagePaginationArray {
}
Resources.ResourceListResponsesV4PagePaginationArray = ResourceListResponsesV4PagePaginationArray;
//# sourceMappingURL=resources.mjs.map