"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.BulkOperations = void 0;
const resource_1 = require("../../../resource.js");
class BulkOperations extends resource_1.APIResource {
    /**
     * Gets the current status of an asynchronous operation on a list.
     *
     * The `status` property can have one of the following values: `pending`,
     * `running`, `completed`, or `failed`. If the status is `failed`, the `error`
     * property will contain a message describing the error.
     */
    get(accountIdentifier, operationId, options) {
        return this._client.get(`/accounts/${accountIdentifier}/rules/lists/bulk_operations/${operationId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.BulkOperations = BulkOperations;
//# sourceMappingURL=bulk-operations.js.map