import { APIResource } from "../../../resource.js";
import * as Core from "../../../core.js";
import * as ListsAPI from "./lists.js";
import { CursorPagination, type CursorPaginationParams } from "../../../pagination.js";
export declare class Items extends APIResource {
    /**
     * Appends new items to the list.
     *
     * This operation is asynchronous. To get current the operation status, invoke the
     * [Get bulk operation status](/operations/lists-get-bulk-operation-status)
     * endpoint with the returned `operation_id`.
     */
    create(listId: string, params: ItemCreateParams, options?: Core.RequestOptions): Core.APIPromise<ItemCreateResponse>;
    /**
     * Removes all existing items from the list and adds the provided items to the
     * list.
     *
     * This operation is asynchronous. To get current the operation status, invoke the
     * [Get bulk operation status](/operations/lists-get-bulk-operation-status)
     * endpoint with the returned `operation_id`.
     */
    update(listId: string, params: ItemUpdateParams, options?: Core.RequestOptions): Core.APIPromise<ItemUpdateResponse>;
    /**
     * Fetches all the items in the list.
     */
    list(listId: string, params: ItemListParams, options?: Core.RequestOptions): Core.PagePromise<ItemListResponsesCursorPagination, ItemListResponse>;
    /**
     * Removes one or more items from a list.
     *
     * This operation is asynchronous. To get current the operation status, invoke the
     * [Get bulk operation status](/operations/lists-get-bulk-operation-status)
     * endpoint with the returned `operation_id`.
     */
    delete(listId: string, params: ItemDeleteParams, options?: Core.RequestOptions): Core.APIPromise<ItemDeleteResponse>;
    /**
     * Fetches a list item in the list.
     */
    get(accountIdentifier: string, listId: string, itemId: string, options?: Core.RequestOptions): Core.APIPromise<ItemGetResponse>;
}
export declare class ItemListResponsesCursorPagination extends CursorPagination<ItemListResponse> {
}
export interface ListCursor {
    after?: string;
    before?: string;
}
export interface ListItem {
    /**
     * The unique operation ID of the asynchronous action.
     */
    operation_id?: string;
}
export interface ItemCreateResponse {
    /**
     * The unique operation ID of the asynchronous action.
     */
    operation_id?: string;
}
export interface ItemUpdateResponse {
    /**
     * The unique operation ID of the asynchronous action.
     */
    operation_id?: string;
}
export interface ItemListResponse {
    /**
     * The unique ID of the list.
     */
    id?: string;
    /**
     * A non-negative 32 bit integer
     */
    asn?: number;
    /**
     * An informative summary of the list item.
     */
    comment?: string;
    /**
     * The RFC 3339 timestamp of when the item was created.
     */
    created_on?: string;
    /**
     * Valid characters for hostnames are ASCII(7) letters from a to z, the digits from
     * 0 to 9, wildcards (\*), and the hyphen (-).
     */
    hostname?: ListsAPI.Hostname;
    /**
     * An IPv4 address, an IPv4 CIDR, or an IPv6 CIDR. IPv6 CIDRs are limited to a
     * maximum of /64.
     */
    ip?: string;
    /**
     * The RFC 3339 timestamp of when the item was last modified.
     */
    modified_on?: string;
    /**
     * The definition of the redirect.
     */
    redirect?: ListsAPI.Redirect;
}
export interface ItemDeleteResponse {
    /**
     * The unique operation ID of the asynchronous action.
     */
    operation_id?: string;
}
export interface ItemGetResponse {
    /**
     * The unique ID of the list.
     */
    id?: string;
    /**
     * A non-negative 32 bit integer
     */
    asn?: number;
    /**
     * An informative summary of the list item.
     */
    comment?: string;
    /**
     * The RFC 3339 timestamp of when the item was created.
     */
    created_on?: string;
    /**
     * Valid characters for hostnames are ASCII(7) letters from a to z, the digits from
     * 0 to 9, wildcards (\*), and the hyphen (-).
     */
    hostname?: ListsAPI.Hostname;
    /**
     * An IPv4 address, an IPv4 CIDR, or an IPv6 CIDR. IPv6 CIDRs are limited to a
     * maximum of /64.
     */
    ip?: string;
    /**
     * The RFC 3339 timestamp of when the item was last modified.
     */
    modified_on?: string;
    /**
     * The definition of the redirect.
     */
    redirect?: ListsAPI.Redirect;
}
export interface ItemCreateParams {
    /**
     * Path param: Identifier
     */
    account_id: string;
    /**
     * Body param:
     */
    body: Array<ItemCreateParams.Body>;
}
export declare namespace ItemCreateParams {
    interface Body {
        /**
         * A non-negative 32 bit integer
         */
        asn?: number;
        /**
         * An informative summary of the list item.
         */
        comment?: string;
        /**
         * Valid characters for hostnames are ASCII(7) letters from a to z, the digits from
         * 0 to 9, wildcards (\*), and the hyphen (-).
         */
        hostname?: ListsAPI.HostnameParam;
        /**
         * An IPv4 address, an IPv4 CIDR, or an IPv6 CIDR. IPv6 CIDRs are limited to a
         * maximum of /64.
         */
        ip?: string;
        /**
         * The definition of the redirect.
         */
        redirect?: ListsAPI.RedirectParam;
    }
}
export interface ItemUpdateParams {
    /**
     * Path param: Identifier
     */
    account_id: string;
    /**
     * Body param:
     */
    body: Array<ItemUpdateParams.Body>;
}
export declare namespace ItemUpdateParams {
    interface Body {
        /**
         * A non-negative 32 bit integer
         */
        asn?: number;
        /**
         * An informative summary of the list item.
         */
        comment?: string;
        /**
         * Valid characters for hostnames are ASCII(7) letters from a to z, the digits from
         * 0 to 9, wildcards (\*), and the hyphen (-).
         */
        hostname?: ListsAPI.HostnameParam;
        /**
         * An IPv4 address, an IPv4 CIDR, or an IPv6 CIDR. IPv6 CIDRs are limited to a
         * maximum of /64.
         */
        ip?: string;
        /**
         * The definition of the redirect.
         */
        redirect?: ListsAPI.RedirectParam;
    }
}
export interface ItemListParams extends CursorPaginationParams {
    /**
     * Path param: Identifier
     */
    account_id: string;
    /**
     * Query param: A search query to filter returned items. Its meaning depends on the
     * list type: IP addresses must start with the provided string, hostnames and bulk
     * redirects must contain the string, and ASNs must match the string exactly.
     */
    search?: string;
}
export interface ItemDeleteParams {
    /**
     * Identifier
     */
    account_id: string;
}
export declare namespace Items {
    export { type ListCursor as ListCursor, type ListItem as ListItem, type ItemCreateResponse as ItemCreateResponse, type ItemUpdateResponse as ItemUpdateResponse, type ItemListResponse as ItemListResponse, type ItemDeleteResponse as ItemDeleteResponse, type ItemGetResponse as ItemGetResponse, ItemListResponsesCursorPagination as ItemListResponsesCursorPagination, type ItemCreateParams as ItemCreateParams, type ItemUpdateParams as ItemUpdateParams, type ItemListParams as ItemListParams, type ItemDeleteParams as ItemDeleteParams, };
}
//# sourceMappingURL=items.d.ts.map