// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
import { CursorPagination } from "../../../pagination.mjs";
export class Items extends APIResource {
    /**
     * Appends new items to the list.
     *
     * This operation is asynchronous. To get current the operation status, invoke the
     * [Get bulk operation status](/operations/lists-get-bulk-operation-status)
     * endpoint with the returned `operation_id`.
     */
    create(listId, params, options) {
        const { account_id, body } = params;
        return this._client.post(`/accounts/${account_id}/rules/lists/${listId}/items`, {
            body: body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Removes all existing items from the list and adds the provided items to the
     * list.
     *
     * This operation is asynchronous. To get current the operation status, invoke the
     * [Get bulk operation status](/operations/lists-get-bulk-operation-status)
     * endpoint with the returned `operation_id`.
     */
    update(listId, params, options) {
        const { account_id, body } = params;
        return this._client.put(`/accounts/${account_id}/rules/lists/${listId}/items`, {
            body: body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetches all the items in the list.
     */
    list(listId, params, options) {
        const { account_id, ...query } = params;
        return this._client.getAPIList(`/accounts/${account_id}/rules/lists/${listId}/items`, ItemListResponsesCursorPagination, { query, ...options });
    }
    /**
     * Removes one or more items from a list.
     *
     * This operation is asynchronous. To get current the operation status, invoke the
     * [Get bulk operation status](/operations/lists-get-bulk-operation-status)
     * endpoint with the returned `operation_id`.
     */
    delete(listId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/rules/lists/${listId}/items`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetches a list item in the list.
     */
    get(accountIdentifier, listId, itemId, options) {
        return this._client.get(`/accounts/${accountIdentifier}/rules/lists/${listId}/items/${itemId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class ItemListResponsesCursorPagination extends CursorPagination {
}
Items.ItemListResponsesCursorPagination = ItemListResponsesCursorPagination;
//# sourceMappingURL=items.mjs.map