"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.Rules = void 0;
const resource_1 = require("../../resource.js");
class Rules extends resource_1.APIResource {
    /**
     * Creates a new rule in a Web Analytics ruleset.
     */
    create(rulesetId, params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/rum/v2/${rulesetId}/rule`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Updates a rule in a Web Analytics ruleset.
     */
    update(rulesetId, ruleId, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/rum/v2/${rulesetId}/rule/${ruleId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Lists all the rules in a Web Analytics ruleset.
     */
    list(rulesetId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/rum/v2/${rulesetId}/rules`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Deletes an existing rule from a Web Analytics ruleset.
     */
    delete(rulesetId, ruleId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/rum/v2/${rulesetId}/rule/${ruleId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Modifies one or more rules in a Web Analytics ruleset with a single request.
     */
    bulkCreate(rulesetId, params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/rum/v2/${rulesetId}/rules`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
}
exports.Rules = Rules;
//# sourceMappingURL=rules.js.map