// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../resource.mjs";
import { V4PagePaginationArray } from "../../pagination.mjs";
export class SiteInfo extends APIResource {
    /**
     * Creates a new Web Analytics site.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/rum/site_info`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Updates an existing Web Analytics site.
     */
    update(siteId, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/rum/site_info/${siteId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Lists all Web Analytics sites of an account.
     */
    list(params, options) {
        const { account_id, ...query } = params;
        return this._client.getAPIList(`/accounts/${account_id}/rum/site_info/list`, SitesV4PagePaginationArray, {
            query,
            ...options,
        });
    }
    /**
     * Deletes an existing Web Analytics site.
     */
    delete(siteId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/rum/site_info/${siteId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Retrieves a Web Analytics site.
     */
    get(siteId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/rum/site_info/${siteId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class SitesV4PagePaginationArray extends V4PagePaginationArray {
}
SiteInfo.SitesV4PagePaginationArray = SitesV4PagePaginationArray;
//# sourceMappingURL=site-info.mjs.map