import { APIResource } from "../resource.js";
import * as Core from "../core.js";
import * as Shared from "./shared.js";
export declare class SecurityTXT extends APIResource {
    /**
     * Update security.txt
     */
    update(params: SecurityTXTUpdateParams, options?: Core.RequestOptions): Core.APIPromise<SecurityTXTUpdateResponse>;
    /**
     * Delete security.txt
     */
    delete(params: SecurityTXTDeleteParams, options?: Core.RequestOptions): Core.APIPromise<SecurityTXTDeleteResponse>;
    /**
     * Get security.txt
     */
    get(params: SecurityTXTGetParams, options?: Core.RequestOptions): Core.APIPromise<SecurityTXTGetResponse>;
}
export interface SecurityTXTUpdateResponse {
    errors: Array<Shared.ResponseInfo>;
    messages: Array<Shared.ResponseInfo>;
    /**
     * Whether the API call was successful
     */
    success: true;
}
export interface SecurityTXTDeleteResponse {
    errors: Array<Shared.ResponseInfo>;
    messages: Array<Shared.ResponseInfo>;
    /**
     * Whether the API call was successful
     */
    success: true;
}
export interface SecurityTXTGetResponse {
    acknowledgments?: Array<string>;
    canonical?: Array<string>;
    contact?: Array<string>;
    enabled?: boolean;
    encryption?: Array<string>;
    expires?: string;
    hiring?: Array<string>;
    policy?: Array<string>;
    preferredLanguages?: string;
}
export interface SecurityTXTUpdateParams {
    /**
     * Path param: Identifier
     */
    zone_id: string;
    /**
     * Body param:
     */
    acknowledgments?: Array<string>;
    /**
     * Body param:
     */
    canonical?: Array<string>;
    /**
     * Body param:
     */
    contact?: Array<string>;
    /**
     * Body param:
     */
    enabled?: boolean;
    /**
     * Body param:
     */
    encryption?: Array<string>;
    /**
     * Body param:
     */
    expires?: string;
    /**
     * Body param:
     */
    hiring?: Array<string>;
    /**
     * Body param:
     */
    policy?: Array<string>;
    /**
     * Body param:
     */
    preferredLanguages?: string;
}
export interface SecurityTXTDeleteParams {
    /**
     * Identifier
     */
    zone_id: string;
}
export interface SecurityTXTGetParams {
    /**
     * Identifier
     */
    zone_id: string;
}
//# sourceMappingURL=security-txt.d.ts.map