"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.SecurityTXT = void 0;
const resource_1 = require("../resource.js");
class SecurityTXT extends resource_1.APIResource {
    /**
     * Update security.txt
     */
    update(params, options) {
        const { zone_id, ...body } = params;
        return this._client.put(`/zones/${zone_id}/security-center/securitytxt`, { body, ...options });
    }
    /**
     * Delete security.txt
     */
    delete(params, options) {
        const { zone_id } = params;
        return this._client.delete(`/zones/${zone_id}/security-center/securitytxt`, options);
    }
    /**
     * Get security.txt
     */
    get(params, options) {
        const { zone_id } = params;
        return this._client.get(`/zones/${zone_id}/security-center/securitytxt`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.SecurityTXT = SecurityTXT;
//# sourceMappingURL=security-txt.js.map