// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../resource.mjs";
import { SinglePage } from "../../pagination.mjs";
export class Rules extends APIResource {
    /**
     * Put Rules
     */
    update(params, options) {
        const { zone_id, ...body } = params;
        return this._client.getAPIList(`/zones/${zone_id}/snippets/snippet_rules`, RuleUpdateResponsesSinglePage, { body, method: 'put', ...options });
    }
    /**
     * Rules
     */
    list(params, options) {
        const { zone_id } = params;
        return this._client.getAPIList(`/zones/${zone_id}/snippets/snippet_rules`, RuleListResponsesSinglePage, options);
    }
    /**
     * Delete All Rules
     */
    delete(params, options) {
        const { zone_id } = params;
        return this._client.delete(`/zones/${zone_id}/snippets/snippet_rules`, options);
    }
}
export class RuleUpdateResponsesSinglePage extends SinglePage {
}
export class RuleListResponsesSinglePage extends SinglePage {
}
Rules.RuleUpdateResponsesSinglePage = RuleUpdateResponsesSinglePage;
Rules.RuleListResponsesSinglePage = RuleListResponsesSinglePage;
//# sourceMappingURL=rules.mjs.map