// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../resource.mjs";
import * as Core from "../../core.mjs";
import * as ContentAPI from "./content.mjs";
import { Content } from "./content.mjs";
import * as RulesAPI from "./rules.mjs";
import { RuleListResponsesSinglePage, RuleUpdateResponsesSinglePage, Rules, } from "./rules.mjs";
import { SinglePage } from "../../pagination.mjs";
export class Snippets extends APIResource {
    constructor() {
        super(...arguments);
        this.content = new ContentAPI.Content(this._client);
        this.rules = new RulesAPI.Rules(this._client);
    }
    /**
     * Put Snippet
     */
    update(snippetName, params, options) {
        const { zone_id, ...body } = params;
        return this._client.put(`/zones/${zone_id}/snippets/${snippetName}`, Core.multipartFormRequestOptions({ body, ...options }))._thenUnwrap((obj) => obj.result);
    }
    /**
     * All Snippets
     */
    list(params, options) {
        const { zone_id } = params;
        return this._client.getAPIList(`/zones/${zone_id}/snippets`, SnippetsSinglePage, options);
    }
    /**
     * Delete Snippet
     */
    delete(snippetName, params, options) {
        const { zone_id } = params;
        return this._client.delete(`/zones/${zone_id}/snippets/${snippetName}`, options);
    }
    /**
     * Snippet
     */
    get(snippetName, params, options) {
        const { zone_id } = params;
        return this._client.get(`/zones/${zone_id}/snippets/${snippetName}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class SnippetsSinglePage extends SinglePage {
}
Snippets.Content = Content;
Snippets.Rules = Rules;
Snippets.RuleUpdateResponsesSinglePage = RuleUpdateResponsesSinglePage;
Snippets.RuleListResponsesSinglePage = RuleListResponsesSinglePage;
//# sourceMappingURL=snippets.mjs.map