import { APIResource } from "../../resource.js";
import * as AnalyzeAPI from "./analyze.js";
import { Analyze, AnalyzeCreateParams, AnalyzeCreateResponse } from "./analyze.js";
import * as RecommendationsAPI from "./recommendations.js";
import { RecommendationGetParams, RecommendationGetResponse, Recommendations } from "./recommendations.js";
import * as VerificationAPI from "./verification.js";
import { Verification, VerificationEditParams, VerificationEditResponse, VerificationGetParams, VerificationGetResponse, VerificationResource } from "./verification.js";
import * as CertificatePacksAPI from "./certificate-packs/certificate-packs.js";
import { CertificatePackCreateParams, CertificatePackCreateResponse, CertificatePackDeleteParams, CertificatePackDeleteResponse, CertificatePackEditParams, CertificatePackEditResponse, CertificatePackGetParams, CertificatePackGetResponse, CertificatePackListParams, CertificatePackListResponse, CertificatePackListResponsesSinglePage, CertificatePacks, Host, RequestValidity, Status, ValidationMethod } from "./certificate-packs/certificate-packs.js";
import * as UniversalAPI from "./universal/universal.js";
import { Universal } from "./universal/universal.js";
export declare class SSL extends APIResource {
    analyze: AnalyzeAPI.Analyze;
    certificatePacks: CertificatePacksAPI.CertificatePacks;
    recommendations: RecommendationsAPI.Recommendations;
    universal: UniversalAPI.Universal;
    verification: VerificationAPI.VerificationResource;
}
export declare namespace SSL {
    export { Analyze as Analyze, type AnalyzeCreateResponse as AnalyzeCreateResponse, type AnalyzeCreateParams as AnalyzeCreateParams, };
    export { CertificatePacks as CertificatePacks, type Host as Host, type RequestValidity as RequestValidity, type Status as Status, type ValidationMethod as ValidationMethod, type CertificatePackCreateResponse as CertificatePackCreateResponse, type CertificatePackListResponse as CertificatePackListResponse, type CertificatePackDeleteResponse as CertificatePackDeleteResponse, type CertificatePackEditResponse as CertificatePackEditResponse, type CertificatePackGetResponse as CertificatePackGetResponse, CertificatePackListResponsesSinglePage as CertificatePackListResponsesSinglePage, type CertificatePackCreateParams as CertificatePackCreateParams, type CertificatePackListParams as CertificatePackListParams, type CertificatePackDeleteParams as CertificatePackDeleteParams, type CertificatePackEditParams as CertificatePackEditParams, type CertificatePackGetParams as CertificatePackGetParams, };
    export { Recommendations as Recommendations, type RecommendationGetResponse as RecommendationGetResponse, type RecommendationGetParams as RecommendationGetParams, };
    export { Universal as Universal };
    export { VerificationResource as VerificationResource, type Verification as Verification, type VerificationEditResponse as VerificationEditResponse, type VerificationGetResponse as VerificationGetResponse, type VerificationEditParams as VerificationEditParams, type VerificationGetParams as VerificationGetParams, };
}
//# sourceMappingURL=ssl.d.ts.map