import { APIResource } from "../../resource.js";
import * as Core from "../../core.js";
import { SinglePage } from "../../pagination.js";
export declare class AudioTracks extends APIResource {
    /**
     * Deletes additional audio tracks on a video. Deleting a default audio track is
     * not allowed. You must assign another audio track as default prior to deletion.
     */
    delete(identifier: string, audioIdentifier: string, params: AudioTrackDeleteParams, options?: Core.RequestOptions): Core.APIPromise<AudioTrackDeleteResponse>;
    /**
     * Adds an additional audio track to a video using the provided audio track URL.
     */
    copy(identifier: string, params: AudioTrackCopyParams, options?: Core.RequestOptions): Core.APIPromise<Audio>;
    /**
     * Edits additional audio tracks on a video. Editing the default status of an audio
     * track to `true` will mark all other audio tracks on the video default status to
     * `false`.
     */
    edit(identifier: string, audioIdentifier: string, params: AudioTrackEditParams, options?: Core.RequestOptions): Core.APIPromise<Audio>;
    /**
     * Lists additional audio tracks on a video. Note this API will not return
     * information for audio attached to the video upload.
     */
    get(identifier: string, params: AudioTrackGetParams, options?: Core.RequestOptions): Core.PagePromise<AudioSinglePage, Audio>;
}
export declare class AudioSinglePage extends SinglePage<Audio> {
}
export interface Audio {
    /**
     * Denotes whether the audio track will be played by default in a player.
     */
    default?: boolean;
    /**
     * A string to uniquely identify the track amongst other audio track labels for the
     * specified video.
     */
    label?: string;
    /**
     * Specifies the processing status of the video.
     */
    status?: 'queued' | 'ready' | 'error';
    /**
     * A Cloudflare-generated unique identifier for a media item.
     */
    uid?: string;
}
export type AudioTrackDeleteResponse = string;
export interface AudioTrackDeleteParams {
    /**
     * The account identifier tag.
     */
    account_id: string;
}
export interface AudioTrackCopyParams {
    /**
     * Path param: The account identifier tag.
     */
    account_id: string;
    /**
     * Body param: A string to uniquely identify the track amongst other audio track
     * labels for the specified video.
     */
    label: string;
    /**
     * Body param: An audio track URL. The server must be publicly routable and support
     * `HTTP HEAD` requests and `HTTP GET` range requests. The server should respond to
     * `HTTP HEAD` requests with a `content-range` header that includes the size of the
     * file.
     */
    url?: string;
}
export interface AudioTrackEditParams {
    /**
     * Path param: The account identifier tag.
     */
    account_id: string;
    /**
     * Body param: Denotes whether the audio track will be played by default in a
     * player.
     */
    default?: boolean;
    /**
     * Body param: A string to uniquely identify the track amongst other audio track
     * labels for the specified video.
     */
    label?: string;
}
export interface AudioTrackGetParams {
    /**
     * The account identifier tag.
     */
    account_id: string;
}
export declare namespace AudioTracks {
    export { type Audio as Audio, type AudioTrackDeleteResponse as AudioTrackDeleteResponse, AudioSinglePage as AudioSinglePage, type AudioTrackDeleteParams as AudioTrackDeleteParams, type AudioTrackCopyParams as AudioTrackCopyParams, type AudioTrackEditParams as AudioTrackEditParams, type AudioTrackGetParams as AudioTrackGetParams, };
}
//# sourceMappingURL=audio-tracks.d.ts.map