"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.AudioSinglePage = exports.AudioTracks = void 0;
const resource_1 = require("../../resource.js");
const pagination_1 = require("../../pagination.js");
class AudioTracks extends resource_1.APIResource {
    /**
     * Deletes additional audio tracks on a video. Deleting a default audio track is
     * not allowed. You must assign another audio track as default prior to deletion.
     */
    delete(identifier, audioIdentifier, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/stream/${identifier}/audio/${audioIdentifier}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Adds an additional audio track to a video using the provided audio track URL.
     */
    copy(identifier, params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/stream/${identifier}/audio/copy`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Edits additional audio tracks on a video. Editing the default status of an audio
     * track to `true` will mark all other audio tracks on the video default status to
     * `false`.
     */
    edit(identifier, audioIdentifier, params, options) {
        const { account_id, ...body } = params;
        return this._client.patch(`/accounts/${account_id}/stream/${identifier}/audio/${audioIdentifier}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Lists additional audio tracks on a video. Note this API will not return
     * information for audio attached to the video upload.
     */
    get(identifier, params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/stream/${identifier}/audio`, AudioSinglePage, options);
    }
}
exports.AudioTracks = AudioTracks;
class AudioSinglePage extends pagination_1.SinglePage {
}
exports.AudioSinglePage = AudioSinglePage;
AudioTracks.AudioSinglePage = AudioSinglePage;
//# sourceMappingURL=audio-tracks.js.map