// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../resource.mjs";
import { SinglePage } from "../../pagination.mjs";
export class AudioTracks extends APIResource {
    /**
     * Deletes additional audio tracks on a video. Deleting a default audio track is
     * not allowed. You must assign another audio track as default prior to deletion.
     */
    delete(identifier, audioIdentifier, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/stream/${identifier}/audio/${audioIdentifier}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Adds an additional audio track to a video using the provided audio track URL.
     */
    copy(identifier, params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/stream/${identifier}/audio/copy`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Edits additional audio tracks on a video. Editing the default status of an audio
     * track to `true` will mark all other audio tracks on the video default status to
     * `false`.
     */
    edit(identifier, audioIdentifier, params, options) {
        const { account_id, ...body } = params;
        return this._client.patch(`/accounts/${account_id}/stream/${identifier}/audio/${audioIdentifier}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Lists additional audio tracks on a video. Note this API will not return
     * information for audio attached to the video upload.
     */
    get(identifier, params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/stream/${identifier}/audio`, AudioSinglePage, options);
    }
}
export class AudioSinglePage extends SinglePage {
}
AudioTracks.AudioSinglePage = AudioSinglePage;
//# sourceMappingURL=audio-tracks.mjs.map