import { APIResource } from "../../../../resource.js";
import * as Core from "../../../../core.js";
import * as CaptionsAPI from "../captions.js";
import * as VttAPI from "./vtt.js";
import { Vtt, VttGetParams, VttGetResponse } from "./vtt.js";
export declare class Language extends APIResource {
    vtt: VttAPI.Vtt;
    /**
     * Generate captions or subtitles for provided language via AI.
     */
    create(identifier: string, language: string, params: LanguageCreateParams, options?: Core.RequestOptions): Core.APIPromise<CaptionsAPI.Caption>;
    /**
     * Uploads the caption or subtitle file to the endpoint for a specific BCP47
     * language. One caption or subtitle file per language is allowed.
     */
    update(identifier: string, language: string, params: LanguageUpdateParams, options?: Core.RequestOptions): Core.APIPromise<CaptionsAPI.Caption>;
    /**
     * Removes the captions or subtitles from a video.
     */
    delete(identifier: string, language: string, params: LanguageDeleteParams, options?: Core.RequestOptions): Core.APIPromise<LanguageDeleteResponse>;
    /**
     * Lists the captions or subtitles for provided language.
     */
    get(identifier: string, language: string, params: LanguageGetParams, options?: Core.RequestOptions): Core.APIPromise<CaptionsAPI.Caption>;
}
export type LanguageDeleteResponse = string;
export interface LanguageCreateParams {
    /**
     * Identifier
     */
    account_id: string;
}
export interface LanguageUpdateParams {
    /**
     * Path param: Identifier
     */
    account_id: string;
    /**
     * Body param: The WebVTT file containing the caption or subtitle content.
     */
    file: string;
}
export interface LanguageDeleteParams {
    /**
     * Identifier
     */
    account_id: string;
}
export interface LanguageGetParams {
    /**
     * Identifier
     */
    account_id: string;
}
export declare namespace Language {
    export { type LanguageDeleteResponse as LanguageDeleteResponse, type LanguageCreateParams as LanguageCreateParams, type LanguageUpdateParams as LanguageUpdateParams, type LanguageDeleteParams as LanguageDeleteParams, type LanguageGetParams as LanguageGetParams, };
    export { Vtt as Vtt, type VttGetResponse as VttGetResponse, type VttGetParams as VttGetParams };
}
//# sourceMappingURL=language.d.ts.map