// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../resource.mjs";
export class Copy extends APIResource {
    /**
     * Uploads a video to Stream from a provided URL.
     */
    create(params, options) {
        const { account_id, 'Upload-Creator': uploadCreator, 'Upload-Metadata': uploadMetadata, ...body } = params;
        return this._client.post(`/accounts/${account_id}/stream/copy`, {
            body,
            ...options,
            headers: {
                ...(uploadCreator != null ? { 'Upload-Creator': uploadCreator } : undefined),
                ...(uploadMetadata != null ? { 'Upload-Metadata': uploadMetadata } : undefined),
                ...options?.headers,
            },
        })._thenUnwrap((obj) => obj.result);
    }
}
//# sourceMappingURL=copy.mjs.map