// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../resource.mjs";
export class Downloads extends APIResource {
    /**
     * Creates a download for a video when a video is ready to view.
     */
    create(identifier, params, options) {
        const { account_id, body } = params;
        return this._client.post(`/accounts/${account_id}/stream/${identifier}/downloads`, {
            body: body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Delete the downloads for a video.
     */
    delete(identifier, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/stream/${identifier}/downloads`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Lists the downloads created for a video.
     */
    get(identifier, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/stream/${identifier}/downloads`, options)._thenUnwrap((obj) => obj.result);
    }
}
//# sourceMappingURL=downloads.mjs.map