// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
import * as OutputsAPI from "./outputs.mjs";
import { Outputs, OutputsSinglePage, } from "./outputs.mjs";
export class LiveInputs extends APIResource {
    constructor() {
        super(...arguments);
        this.outputs = new OutputsAPI.Outputs(this._client);
    }
    /**
     * Creates a live input, and returns credentials that you or your users can use to
     * stream live video to Cloudflare Stream.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/stream/live_inputs`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Updates a specified live input.
     */
    update(liveInputIdentifier, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/stream/live_inputs/${liveInputIdentifier}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Lists the live inputs created for an account. To get the credentials needed to
     * stream to a specific live input, request a single live input.
     */
    list(params, options) {
        const { account_id, ...query } = params;
        return this._client.get(`/accounts/${account_id}/stream/live_inputs`, {
            query,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Prevents a live input from being streamed to and makes the live input
     * inaccessible to any future API calls.
     */
    delete(liveInputIdentifier, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/stream/live_inputs/${liveInputIdentifier}`, {
            ...options,
            headers: { Accept: '*/*', ...options?.headers },
        });
    }
    /**
     * Retrieves details of an existing live input.
     */
    get(liveInputIdentifier, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/stream/live_inputs/${liveInputIdentifier}`, options)._thenUnwrap((obj) => obj.result);
    }
}
LiveInputs.Outputs = Outputs;
LiveInputs.OutputsSinglePage = OutputsSinglePage;
//# sourceMappingURL=live-inputs.mjs.map