// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
import { SinglePage } from "../../../pagination.mjs";
export class Outputs extends APIResource {
    /**
     * Creates a new output that can be used to simulcast or restream live video to
     * other RTMP or SRT destinations. Outputs are always linked to a specific live
     * input — one live input can have many outputs.
     */
    create(liveInputIdentifier, params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/stream/live_inputs/${liveInputIdentifier}/outputs`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Updates the state of an output.
     */
    update(liveInputIdentifier, outputIdentifier, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/stream/live_inputs/${liveInputIdentifier}/outputs/${outputIdentifier}`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Retrieves all outputs associated with a specified live input.
     */
    list(liveInputIdentifier, params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/stream/live_inputs/${liveInputIdentifier}/outputs`, OutputsSinglePage, options);
    }
    /**
     * Deletes an output and removes it from the associated live input.
     */
    delete(liveInputIdentifier, outputIdentifier, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/stream/live_inputs/${liveInputIdentifier}/outputs/${outputIdentifier}`, { ...options, headers: { Accept: '*/*', ...options?.headers } });
    }
}
export class OutputsSinglePage extends SinglePage {
}
Outputs.OutputsSinglePage = OutputsSinglePage;
//# sourceMappingURL=outputs.mjs.map