// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../resource.mjs";
import * as Core from "../../core.mjs";
import { SinglePage } from "../../pagination.mjs";
export class Watermarks extends APIResource {
    /**
     * Creates watermark profiles using a single `HTTP POST multipart/form-data`
     * request.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/stream/watermarks`, Core.multipartFormRequestOptions({ body, ...options }))._thenUnwrap((obj) => obj.result);
    }
    /**
     * Lists all watermark profiles for an account.
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/stream/watermarks`, WatermarksSinglePage, options);
    }
    /**
     * Deletes a watermark profile.
     */
    delete(identifier, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/stream/watermarks/${identifier}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Retrieves details for a single watermark profile.
     */
    get(identifier, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/stream/watermarks/${identifier}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class WatermarksSinglePage extends SinglePage {
}
Watermarks.WatermarksSinglePage = WatermarksSinglePage;
//# sourceMappingURL=watermarks.mjs.map