"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.Webhooks = void 0;
const resource_1 = require("../../resource.js");
class Webhooks extends resource_1.APIResource {
    /**
     * Creates a webhook notification.
     */
    update(params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/stream/webhook`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Deletes a webhook.
     */
    delete(params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/stream/webhook`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Retrieves a list of webhooks.
     */
    get(params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/stream/webhook`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.Webhooks = Webhooks;
//# sourceMappingURL=webhooks.js.map