import { APIResource } from "../resource.js";
import * as Core from "../core.js";
export declare class URLNormalization extends APIResource {
    /**
     * Updates the URL Normalization settings.
     */
    update(params: URLNormalizationUpdateParams, options?: Core.RequestOptions): Core.APIPromise<URLNormalizationUpdateResponse>;
    /**
     * Deletes the URL Normalization settings.
     */
    delete(params: URLNormalizationDeleteParams, options?: Core.RequestOptions): Core.APIPromise<void>;
    /**
     * Fetches the current URL Normalization settings.
     */
    get(params: URLNormalizationGetParams, options?: Core.RequestOptions): Core.APIPromise<URLNormalizationGetResponse>;
}
/**
 * A result.
 */
export interface URLNormalizationUpdateResponse {
    /**
     * The scope of the URL normalization.
     */
    scope: 'incoming' | 'both';
    /**
     * The type of URL normalization performed by Cloudflare.
     */
    type: 'cloudflare' | 'rfc3986';
}
/**
 * A result.
 */
export interface URLNormalizationGetResponse {
    /**
     * The scope of the URL normalization.
     */
    scope: 'incoming' | 'both';
    /**
     * The type of URL normalization performed by Cloudflare.
     */
    type: 'cloudflare' | 'rfc3986';
}
export interface URLNormalizationUpdateParams {
    /**
     * Path param: The unique ID of the zone.
     */
    zone_id: string;
    /**
     * Body param: The scope of the URL normalization.
     */
    scope: 'incoming' | 'both';
    /**
     * Body param: The type of URL normalization performed by Cloudflare.
     */
    type: 'cloudflare' | 'rfc3986';
}
export interface URLNormalizationDeleteParams {
    /**
     * The unique ID of the zone.
     */
    zone_id: string;
}
export interface URLNormalizationGetParams {
    /**
     * The unique ID of the zone.
     */
    zone_id: string;
}
//# sourceMappingURL=url-normalization.d.ts.map