// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../resource.mjs";
export class Scans extends APIResource {
    /**
     * Submit a URL to scan. Check limits at
     * https://developers.cloudflare.com/security-center/investigate/scan-limits/.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/urlscanner/v2/scan`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Use a subset of ElasticSearch Query syntax to filter scans. Some example
     * queries:<br/> <br/>- 'path:"/bundles/jquery.js"': Searches for scans who
     * requested resources with the given path.<br/>- 'page.asn:AS24940 AND hash:xxx':
     * Websites hosted in AS24940 where a resource with the given hash was
     * downloaded.<br/>- 'page.domain:microsoft\* AND verdicts.malicious:true AND NOT
     * page.domain:microsoft.com': malicious scans whose hostname starts with
     * "microsoft".<br/>- 'apikey:me AND date:[2025-01 TO 2025-02]': my scans from 2025
     * January to 2025 February.
     */
    list(params, options) {
        const { account_id, ...query } = params;
        return this._client.get(`/accounts/${account_id}/urlscanner/v2/search`, { query, ...options });
    }
    /**
     * Submit URLs to scan. Check limits at
     * https://developers.cloudflare.com/security-center/investigate/scan-limits/ and
     * take into account scans submitted in bulk have lower priority and may take
     * longer to finish.
     */
    bulkCreate(params, options) {
        const { account_id, body } = params ?? {};
        return this._client.post(`/accounts/${account_id}/urlscanner/v2/bulk`, { body: body, ...options });
    }
    /**
     * Returns a plain text response, with the scan's DOM content as rendered by
     * Chrome.
     */
    dom(scanId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/urlscanner/v2/dom/${scanId}`, {
            ...options,
            headers: { Accept: 'text/plain', ...options?.headers },
        });
    }
    /**
     * Get URL scan by uuid
     */
    get(scanId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/urlscanner/v2/result/${scanId}`, options);
    }
    /**
     * Get a URL scan's HAR file. See HAR spec at
     * http://www.softwareishard.com/blog/har-12-spec/.
     */
    har(scanId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/urlscanner/v2/har/${scanId}`, options);
    }
    /**
     * Get scan's screenshot by resolution (desktop/mobile/tablet).
     */
    screenshot(scanId, params, options) {
        const { account_id, ...query } = params;
        return this._client.get(`/accounts/${account_id}/urlscanner/v2/screenshots/${scanId}.png`, {
            query,
            ...options,
            headers: { Accept: 'image/png', ...options?.headers },
            __binaryResponse: true,
        });
    }
}
//# sourceMappingURL=scans.mjs.map