"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvitesSinglePage = exports.Invites = void 0;
const resource_1 = require("../../resource.js");
const pagination_1 = require("../../pagination.js");
class Invites extends resource_1.APIResource {
    /**
     * Lists all invitations associated with my user.
     */
    list(options) {
        return this._client.getAPIList('/user/invites', InvitesSinglePage, options);
    }
    /**
     * Responds to an invitation.
     */
    edit(inviteId, body, options) {
        return this._client.patch(`/user/invites/${inviteId}`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Gets the details of an invitation.
     */
    get(inviteId, options) {
        return this._client.get(`/user/invites/${inviteId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.Invites = Invites;
class InvitesSinglePage extends pagination_1.SinglePage {
}
exports.InvitesSinglePage = InvitesSinglePage;
Invites.InvitesSinglePage = InvitesSinglePage;
//# sourceMappingURL=invites.js.map