// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../resource.mjs";
import { SinglePage } from "../../pagination.mjs";
export class Invites extends APIResource {
    /**
     * Lists all invitations associated with my user.
     */
    list(options) {
        return this._client.getAPIList('/user/invites', InvitesSinglePage, options);
    }
    /**
     * Responds to an invitation.
     */
    edit(inviteId, body, options) {
        return this._client.patch(`/user/invites/${inviteId}`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Gets the details of an invitation.
     */
    get(inviteId, options) {
        return this._client.get(`/user/invites/${inviteId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class InvitesSinglePage extends SinglePage {
}
Invites.InvitesSinglePage = InvitesSinglePage;
//# sourceMappingURL=invites.mjs.map