"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.SubscriptionsSinglePage = exports.Subscriptions = void 0;
const resource_1 = require("../../resource.js");
const shared_1 = require("../shared.js");
Object.defineProperty(exports, "SubscriptionsSinglePage", { enumerable: true, get: function () { return shared_1.SubscriptionsSinglePage; } });
class Subscriptions extends resource_1.APIResource {
    /**
     * Updates a user's subscriptions.
     */
    update(identifier, body, options) {
        return this._client.put(`/user/subscriptions/${identifier}`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Deletes a user's subscription.
     */
    delete(identifier, options) {
        return this._client.delete(`/user/subscriptions/${identifier}`, options);
    }
    /**
     * Lists all of a user's subscriptions.
     */
    get(options) {
        return this._client.getAPIList('/user/subscriptions', shared_1.SubscriptionsSinglePage, options);
    }
}
exports.Subscriptions = Subscriptions;
//# sourceMappingURL=subscriptions.js.map