// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../resource.mjs";
import { SubscriptionsSinglePage } from "../shared.mjs";
export class Subscriptions extends APIResource {
    /**
     * Updates a user's subscriptions.
     */
    update(identifier, body, options) {
        return this._client.put(`/user/subscriptions/${identifier}`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Deletes a user's subscription.
     */
    delete(identifier, options) {
        return this._client.delete(`/user/subscriptions/${identifier}`, options);
    }
    /**
     * Lists all of a user's subscriptions.
     */
    get(options) {
        return this._client.getAPIList('/user/subscriptions', SubscriptionsSinglePage, options);
    }
}
export { SubscriptionsSinglePage };
//# sourceMappingURL=subscriptions.mjs.map