// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
import { isRequestOptions } from "../../../core.mjs";
import { TokensV4PagePaginationArray } from "../../shared.mjs";
import * as PermissionGroupsAPI from "./permission-groups.mjs";
import { PermissionGroupListResponsesSinglePage, PermissionGroups, } from "./permission-groups.mjs";
import * as ValueAPI from "./value.mjs";
import { Value } from "./value.mjs";
export class Tokens extends APIResource {
    constructor() {
        super(...arguments);
        this.permissionGroups = new PermissionGroupsAPI.PermissionGroups(this._client);
        this.value = new ValueAPI.Value(this._client);
    }
    /**
     * Create a new access token.
     */
    create(body, options) {
        return this._client.post('/user/tokens', { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Update an existing token.
     */
    update(tokenId, body, options) {
        return this._client.put(`/user/tokens/${tokenId}`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    list(query = {}, options) {
        if (isRequestOptions(query)) {
            return this.list({}, query);
        }
        return this._client.getAPIList('/user/tokens', TokensV4PagePaginationArray, { query, ...options });
    }
    /**
     * Destroy a token.
     */
    delete(tokenId, options) {
        return this._client.delete(`/user/tokens/${tokenId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get information about a specific token.
     */
    get(tokenId, options) {
        return this._client.get(`/user/tokens/${tokenId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Test whether a token works.
     */
    verify(options) {
        return this._client.get('/user/tokens/verify', options)._thenUnwrap((obj) => obj.result);
    }
}
Tokens.PermissionGroups = PermissionGroups;
Tokens.PermissionGroupListResponsesSinglePage = PermissionGroupListResponsesSinglePage;
Tokens.Value = Value;
export { TokensV4PagePaginationArray };
//# sourceMappingURL=tokens.mjs.map