// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
import * as MetadataIndexAPI from "./metadata-index.mjs";
import { MetadataIndex, } from "./metadata-index.mjs";
import { SinglePage } from "../../../pagination.mjs";
export class Indexes extends APIResource {
    constructor() {
        super(...arguments);
        this.metadataIndex = new MetadataIndexAPI.MetadataIndex(this._client);
    }
    /**
     * Creates and returns a new Vectorize Index.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/vectorize/v2/indexes`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Returns a list of Vectorize Indexes
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/vectorize/v2/indexes`, CreateIndicesSinglePage, options);
    }
    /**
     * Deletes the specified Vectorize Index.
     */
    delete(indexName, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/vectorize/v2/indexes/${indexName}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Delete a set of vectors from an index by their vector identifiers.
     */
    deleteByIds(indexName, params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/vectorize/v2/indexes/${indexName}/delete_by_ids`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Returns the specified Vectorize Index.
     */
    get(indexName, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/vectorize/v2/indexes/${indexName}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get a set of vectors from an index by their vector identifiers.
     */
    getByIds(indexName, params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/vectorize/v2/indexes/${indexName}/get_by_ids`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get information about a vectorize index.
     */
    info(indexName, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/vectorize/v2/indexes/${indexName}/info`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Inserts vectors into the specified index and returns a mutation id corresponding
     * to the vectors enqueued for insertion.
     */
    insert(indexName, params, options) {
        const { account_id, body, 'unparsable-behavior': unparsableBehavior } = params;
        return this._client.post(`/accounts/${account_id}/vectorize/v2/indexes/${indexName}/insert`, {
            query: { 'unparsable-behavior': unparsableBehavior },
            body: body,
            ...options,
            headers: { 'Content-Type': 'application/x-ndjson', ...options?.headers },
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Finds vectors closest to a given vector in an index.
     */
    query(indexName, params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/vectorize/v2/indexes/${indexName}/query`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Upserts vectors into the specified index, creating them if they do not exist and
     * returns a mutation id corresponding to the vectors enqueued for upsertion.
     */
    upsert(indexName, params, options) {
        const { account_id, body, 'unparsable-behavior': unparsableBehavior } = params;
        return this._client.post(`/accounts/${account_id}/vectorize/v2/indexes/${indexName}/upsert`, {
            query: { 'unparsable-behavior': unparsableBehavior },
            body: body,
            ...options,
            headers: { 'Content-Type': 'application/x-ndjson', ...options?.headers },
        })._thenUnwrap((obj) => obj.result);
    }
}
export class CreateIndicesSinglePage extends SinglePage {
}
Indexes.CreateIndicesSinglePage = CreateIndicesSinglePage;
Indexes.MetadataIndex = MetadataIndex;
//# sourceMappingURL=indexes.mjs.map