// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
export class MetadataIndex extends APIResource {
    /**
     * Enable metadata filtering based on metadata property. Limited to 10 properties.
     */
    create(indexName, params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/vectorize/v2/indexes/${indexName}/metadata_index/create`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List Metadata Indexes for the specified Vectorize Index.
     */
    list(indexName, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/vectorize/v2/indexes/${indexName}/metadata_index/list`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Allow Vectorize to delete the specified metadata index.
     */
    delete(indexName, params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/vectorize/v2/indexes/${indexName}/metadata_index/delete`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
}
//# sourceMappingURL=metadata-index.mjs.map