// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
import * as DetailsAPI from "./details.mjs";
import { Details } from "./details.mjs";
import { V4PagePaginationArray } from "../../../pagination.mjs";
export class Events extends APIResource {
    constructor() {
        super(...arguments);
        this.details = new DetailsAPI.Details(this._client);
    }
    /**
     * Only available for the Waiting Room Advanced subscription. Creates an event for
     * a waiting room. An event takes place during a specified period of time,
     * temporarily changing the behavior of a waiting room. While the event is active,
     * some of the properties in the event's configuration may either override or
     * inherit from the waiting room's configuration. Note that events cannot overlap
     * with each other, so only one event can be active at a time.
     */
    create(waitingRoomId, params, options) {
        const { zone_id, ...body } = params;
        return this._client.post(`/zones/${zone_id}/waiting_rooms/${waitingRoomId}/events`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Updates a configured event for a waiting room.
     */
    update(waitingRoomId, eventId, params, options) {
        const { zone_id, ...body } = params;
        return this._client.put(`/zones/${zone_id}/waiting_rooms/${waitingRoomId}/events/${eventId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Lists events for a waiting room.
     */
    list(waitingRoomId, params, options) {
        const { zone_id, ...query } = params;
        return this._client.getAPIList(`/zones/${zone_id}/waiting_rooms/${waitingRoomId}/events`, EventsV4PagePaginationArray, { query, ...options });
    }
    /**
     * Deletes an event for a waiting room.
     */
    delete(waitingRoomId, eventId, params, options) {
        const { zone_id } = params;
        return this._client.delete(`/zones/${zone_id}/waiting_rooms/${waitingRoomId}/events/${eventId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Patches a configured event for a waiting room.
     */
    edit(waitingRoomId, eventId, params, options) {
        const { zone_id, ...body } = params;
        return this._client.patch(`/zones/${zone_id}/waiting_rooms/${waitingRoomId}/events/${eventId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetches a single configured event for a waiting room.
     */
    get(waitingRoomId, eventId, params, options) {
        const { zone_id } = params;
        return this._client.get(`/zones/${zone_id}/waiting_rooms/${waitingRoomId}/events/${eventId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class EventsV4PagePaginationArray extends V4PagePaginationArray {
}
Events.EventsV4PagePaginationArray = EventsV4PagePaginationArray;
Events.Details = Details;
//# sourceMappingURL=events.mjs.map