"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.WaitingRoomRulesSinglePage = exports.Rules = void 0;
const resource_1 = require("../../resource.js");
const pagination_1 = require("../../pagination.js");
class Rules extends resource_1.APIResource {
    /**
     * Only available for the Waiting Room Advanced subscription. Creates a rule for a
     * waiting room.
     */
    create(waitingRoomId, params, options) {
        const { zone_id, rules } = params;
        return this._client.getAPIList(`/zones/${zone_id}/waiting_rooms/${waitingRoomId}/rules`, WaitingRoomRulesSinglePage, { body: rules, method: 'post', ...options });
    }
    /**
     * Only available for the Waiting Room Advanced subscription. Replaces all rules
     * for a waiting room.
     */
    update(waitingRoomId, params, options) {
        const { zone_id, rules } = params;
        return this._client.getAPIList(`/zones/${zone_id}/waiting_rooms/${waitingRoomId}/rules`, WaitingRoomRulesSinglePage, { body: rules, method: 'put', ...options });
    }
    /**
     * Deletes a rule for a waiting room.
     */
    delete(waitingRoomId, ruleId, params, options) {
        const { zone_id } = params;
        return this._client.getAPIList(`/zones/${zone_id}/waiting_rooms/${waitingRoomId}/rules/${ruleId}`, WaitingRoomRulesSinglePage, { method: 'delete', ...options });
    }
    /**
     * Patches a rule for a waiting room.
     */
    edit(waitingRoomId, ruleId, params, options) {
        const { zone_id, ...body } = params;
        return this._client.getAPIList(`/zones/${zone_id}/waiting_rooms/${waitingRoomId}/rules/${ruleId}`, WaitingRoomRulesSinglePage, { body, method: 'patch', ...options });
    }
    /**
     * Lists rules for a waiting room.
     */
    get(waitingRoomId, params, options) {
        const { zone_id } = params;
        return this._client.getAPIList(`/zones/${zone_id}/waiting_rooms/${waitingRoomId}/rules`, WaitingRoomRulesSinglePage, options);
    }
}
exports.Rules = Rules;
class WaitingRoomRulesSinglePage extends pagination_1.SinglePage {
}
exports.WaitingRoomRulesSinglePage = WaitingRoomRulesSinglePage;
Rules.WaitingRoomRulesSinglePage = WaitingRoomRulesSinglePage;
//# sourceMappingURL=rules.js.map