import { APIResource } from "../../resource.js";
import * as Core from "../../core.js";
export declare class Settings extends APIResource {
    /**
     * Update zone-level Waiting Room settings
     */
    update(params: SettingUpdateParams, options?: Core.RequestOptions): Core.APIPromise<SettingUpdateResponse>;
    /**
     * Patch zone-level Waiting Room settings
     */
    edit(params: SettingEditParams, options?: Core.RequestOptions): Core.APIPromise<SettingEditResponse>;
    /**
     * Get zone-level Waiting Room settings
     */
    get(params: SettingGetParams, options?: Core.RequestOptions): Core.APIPromise<SettingGetResponse>;
}
export interface Setting {
    /**
     * Whether to allow verified search engine crawlers to bypass all waiting rooms on
     * this zone. Verified search engine crawlers will not be tracked or counted by the
     * waiting room system, and will not appear in waiting room analytics.
     */
    search_engine_crawler_bypass: boolean;
}
export interface SettingUpdateResponse {
    /**
     * Whether to allow verified search engine crawlers to bypass all waiting rooms on
     * this zone. Verified search engine crawlers will not be tracked or counted by the
     * waiting room system, and will not appear in waiting room analytics.
     */
    search_engine_crawler_bypass: boolean;
}
export interface SettingEditResponse {
    /**
     * Whether to allow verified search engine crawlers to bypass all waiting rooms on
     * this zone. Verified search engine crawlers will not be tracked or counted by the
     * waiting room system, and will not appear in waiting room analytics.
     */
    search_engine_crawler_bypass: boolean;
}
export interface SettingGetResponse {
    /**
     * Whether to allow verified search engine crawlers to bypass all waiting rooms on
     * this zone. Verified search engine crawlers will not be tracked or counted by the
     * waiting room system, and will not appear in waiting room analytics.
     */
    search_engine_crawler_bypass: boolean;
}
export interface SettingUpdateParams {
    /**
     * Path param: Identifier
     */
    zone_id: string;
    /**
     * Body param: Whether to allow verified search engine crawlers to bypass all
     * waiting rooms on this zone. Verified search engine crawlers will not be tracked
     * or counted by the waiting room system, and will not appear in waiting room
     * analytics.
     */
    search_engine_crawler_bypass?: boolean;
}
export interface SettingEditParams {
    /**
     * Path param: Identifier
     */
    zone_id: string;
    /**
     * Body param: Whether to allow verified search engine crawlers to bypass all
     * waiting rooms on this zone. Verified search engine crawlers will not be tracked
     * or counted by the waiting room system, and will not appear in waiting room
     * analytics.
     */
    search_engine_crawler_bypass?: boolean;
}
export interface SettingGetParams {
    /**
     * Identifier
     */
    zone_id: string;
}
export declare namespace Settings {
    export { type Setting as Setting, type SettingUpdateResponse as SettingUpdateResponse, type SettingEditResponse as SettingEditResponse, type SettingGetResponse as SettingGetResponse, type SettingUpdateParams as SettingUpdateParams, type SettingEditParams as SettingEditParams, type SettingGetParams as SettingGetParams, };
}
//# sourceMappingURL=settings.d.ts.map