import { APIResource } from "../../../resource.js";
import * as Core from "../../../core.js";
import * as IPFSUniversalPathsAPI from "./ipfs-universal-paths/ipfs-universal-paths.js";
import { IPFSUniversalPaths } from "./ipfs-universal-paths/ipfs-universal-paths.js";
import { SinglePage } from "../../../pagination.js";
export declare class Hostnames extends APIResource {
    ipfsUniversalPaths: IPFSUniversalPathsAPI.IPFSUniversalPaths;
    /**
     * Create Web3 Hostname
     */
    create(params: HostnameCreateParams, options?: Core.RequestOptions): Core.APIPromise<Hostname>;
    /**
     * List Web3 Hostnames
     */
    list(params: HostnameListParams, options?: Core.RequestOptions): Core.PagePromise<HostnamesSinglePage, Hostname>;
    /**
     * Delete Web3 Hostname
     */
    delete(identifier: string, params: HostnameDeleteParams, options?: Core.RequestOptions): Core.APIPromise<HostnameDeleteResponse | null>;
    /**
     * Edit Web3 Hostname
     */
    edit(identifier: string, params: HostnameEditParams, options?: Core.RequestOptions): Core.APIPromise<Hostname>;
    /**
     * Web3 Hostname Details
     */
    get(identifier: string, params: HostnameGetParams, options?: Core.RequestOptions): Core.APIPromise<Hostname>;
}
export declare class HostnamesSinglePage extends SinglePage<Hostname> {
}
export interface Hostname {
    /**
     * Identifier
     */
    id?: string;
    created_on?: string;
    /**
     * An optional description of the hostname.
     */
    description?: string;
    /**
     * DNSLink value used if the target is ipfs.
     */
    dnslink?: string;
    modified_on?: string;
    /**
     * The hostname that will point to the target gateway via CNAME.
     */
    name?: string;
    /**
     * Status of the hostname's activation.
     */
    status?: 'active' | 'pending' | 'deleting' | 'error';
    /**
     * Target gateway of the hostname.
     */
    target?: 'ethereum' | 'ipfs' | 'ipfs_universal_path';
}
export interface HostnameDeleteResponse {
    /**
     * Identifier
     */
    id: string;
}
export interface HostnameCreateParams {
    /**
     * Path param: Identifier
     */
    zone_id: string;
    /**
     * Body param: The hostname that will point to the target gateway via CNAME.
     */
    name: string;
    /**
     * Body param: Target gateway of the hostname.
     */
    target: 'ethereum' | 'ipfs' | 'ipfs_universal_path';
    /**
     * Body param: An optional description of the hostname.
     */
    description?: string;
    /**
     * Body param: DNSLink value used if the target is ipfs.
     */
    dnslink?: string;
}
export interface HostnameListParams {
    /**
     * Identifier
     */
    zone_id: string;
}
export interface HostnameDeleteParams {
    /**
     * Identifier
     */
    zone_id: string;
}
export interface HostnameEditParams {
    /**
     * Path param: Identifier
     */
    zone_id: string;
    /**
     * Body param: An optional description of the hostname.
     */
    description?: string;
    /**
     * Body param: DNSLink value used if the target is ipfs.
     */
    dnslink?: string;
}
export interface HostnameGetParams {
    /**
     * Identifier
     */
    zone_id: string;
}
export declare namespace Hostnames {
    export { type Hostname as Hostname, type HostnameDeleteResponse as HostnameDeleteResponse, HostnamesSinglePage as HostnamesSinglePage, type HostnameCreateParams as HostnameCreateParams, type HostnameListParams as HostnameListParams, type HostnameDeleteParams as HostnameDeleteParams, type HostnameEditParams as HostnameEditParams, type HostnameGetParams as HostnameGetParams, };
    export { IPFSUniversalPaths as IPFSUniversalPaths };
}
//# sourceMappingURL=hostnames.d.ts.map