// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
import * as IPFSUniversalPathsAPI from "./ipfs-universal-paths/ipfs-universal-paths.mjs";
import { IPFSUniversalPaths } from "./ipfs-universal-paths/ipfs-universal-paths.mjs";
import { SinglePage } from "../../../pagination.mjs";
export class Hostnames extends APIResource {
    constructor() {
        super(...arguments);
        this.ipfsUniversalPaths = new IPFSUniversalPathsAPI.IPFSUniversalPaths(this._client);
    }
    /**
     * Create Web3 Hostname
     */
    create(params, options) {
        const { zone_id, ...body } = params;
        return this._client.post(`/zones/${zone_id}/web3/hostnames`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List Web3 Hostnames
     */
    list(params, options) {
        const { zone_id } = params;
        return this._client.getAPIList(`/zones/${zone_id}/web3/hostnames`, HostnamesSinglePage, options);
    }
    /**
     * Delete Web3 Hostname
     */
    delete(identifier, params, options) {
        const { zone_id } = params;
        return this._client.delete(`/zones/${zone_id}/web3/hostnames/${identifier}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Edit Web3 Hostname
     */
    edit(identifier, params, options) {
        const { zone_id, ...body } = params;
        return this._client.patch(`/zones/${zone_id}/web3/hostnames/${identifier}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Web3 Hostname Details
     */
    get(identifier, params, options) {
        const { zone_id } = params;
        return this._client.get(`/zones/${zone_id}/web3/hostnames/${identifier}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class HostnamesSinglePage extends SinglePage {
}
Hostnames.HostnamesSinglePage = HostnamesSinglePage;
Hostnames.IPFSUniversalPaths = IPFSUniversalPaths;
//# sourceMappingURL=hostnames.mjs.map